% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aba.R
\name{iBoxcoxTr}
\alias{iBoxcoxTr}
\title{Inverse Box-Cox transformation}
\usage{
iBoxcoxTr(x, lambda)
}
\arguments{
\item{x}{vector or RasterLayer. values to be transformed}

\item{lambda}{numeric. parameter of Box-Cox transformation}
}
\value{
a vector or RasterLayer of transformed values
}
\description{
Inverse Box-Cox transformation
}
\examples{
x <- 1:10
iBoxcoxTr(x, 0)
iBoxcoxTr(x, 0.5)
iBoxcoxTr(x, 2)
iBoxcoxTr(BoxcoxTr(x,2), 2)

# plot functions
curve(iBoxcoxTr(x, 0), 0, 3, col = "blue", main = "inverse Box Cox transf.",
xlab = "x", ylab = "inverse Boxcox(x, lambda)")
curve(iBoxcoxTr(x, 1.5), 0, 3, col = "red", add = TRUE)
curve(iBoxcoxTr(x, 0.5), 0, 3,  col = "black", add = TRUE)
curve(iBoxcoxTr(x, 1), 0, 3, col = "pink", add = TRUE)
legend("topleft", legend = c("lambda", 0, 0.5, 1, 1.5),
col = c(NA, "blue", "black", "pink", "red"), lty = 1)
}
\seealso{
\code{\link{BoxcoxTr}} Box-Cox transformation, \code{\link{iBoxcoxTrBiasCor}} inverse Box-Cox transformation with bias correction.
}
