% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aba.R
\name{boxcox_tr}
\alias{boxcox_tr}
\title{Box-Cox Transformation}
\usage{
boxcox_tr(x, lambda)
}
\arguments{
\item{x}{vector or RasterLayer. values to be transformed}

\item{lambda}{numeric. parameter of Box-Cox transformation}
}
\value{
a vector or RasterLayer of transformed values
}
\description{
Box-Cox Transformation
}
\examples{
x <- 1:10
boxcox_tr(x, -2)
boxcox_tr(x, 0)
boxcox_tr(x, 0.5)
boxcox_tr(x, 2)

# plot functions
curve(boxcox_tr(x, 1.5), 1, 5,
  main = "Box Cox transform", xlab = "x",
  ylab = "Boxcox(x, lambda)", col = "red"
)
curve(boxcox_tr(x, -2), 1, 5, col = "green", add = TRUE)
curve(boxcox_tr(x, 0), 1, 5, col = "blue", add = TRUE)
curve(boxcox_tr(x, 0.5), 1, 5, col = "black", add = TRUE)
curve(boxcox_tr(x, 1), 1, 5, col = "pink", add = TRUE)
legend("topleft",
  legend = rev(c(-2, 0, 0.5, 1, 1.5, "lambda")),
  col = rev(c("green", "blue", "black", "pink", "red", NA)), lty = 1
)
}
\seealso{
\code{\link{boxcox_itr}} inverse Box-Cox transformation,
\code{\link{boxcox_itr_bias_cor}} inverse Box-Cox transformation with bias correction.
}
