% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_actuarialFunctions.R
\name{Exn}
\alias{Exn}
\title{Function to evaluate the pure endowment}
\usage{
Exn(actuarialtable, x, n, i = actuarialtable@interest, type = "EV",
  power = 1)
}
\arguments{
\item{actuarialtable}{An actuarial table object.}

\item{x}{Age of the insured.}

\item{n}{Length of the contract.}

\item{i}{Interest rate (it overwrites the \code{actuarialtable} one)}

\item{type}{A string, eithed "EV" (default value),  "ST" (stocastic realization) or "VR" if the value of the variance is needed.}

\item{power}{The power of the APV. Default is 1 (mean)}
}
\value{
The APV of the contract
}
\description{
Function to evaluate the pure endowment
}
\examples{

#assumes SOA example life table to be load
data(soaLt)
soa08Act=with(soaLt, new("actuarialtable",interest=0.06, x=x,lx=Ix,name="SOA2008"))
#evaluate the pure endowment for a man aged 30 for a time span of 35
Exn(soa08Act, x=30, n=35) 
}
\references{
Actuarial Mathematics (Second Edition), 1997, by Bowers, N.L., Gerber, H.U., 
Hickman, J.C., Jones, D.A. and Nesbitt, C.J.
}
\seealso{
\code{\link{axn}}, \code{\link{Axn}}
}
\author{
Giorgio A. Spedicato
}
