% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve.R
\name{is_solved}
\alias{is_solved}
\title{Is the given board is a solved state?}
\usage{
is_solved(board)
}
\arguments{
\item{board}{A \code{lightsout} board}
}
\value{
\code{TRUE} if the given board is solved; \code{FALSE} otherwise.
}
\description{
A board is considered solved if all the lights are switched off (have a state of \code{0}).
}
\examples{
# Create a board solved with one move and solve it.
lights <- c(1, 1, 0,
            1, 0, 0,
            0, 0, 0 )
board <- new_board(lights)
is_solved(board)
board <- board \%>\% play(1, 1)
is_solved(board)
}
\seealso{
\code{\link[lightsout]{is_solvable}}
\code{\link[lightsout]{solve_board}}
}

