\name{evaluate} 
\alias{evaluate} 
\title{likeLTD::evaluate} 
\usage{evaluate(P.pars, D.pars, tolerance=1e-5, n.steps=NULL, progBar=TRUE, interim=TRUE, 
CR.start=0.1, CR.end=0.7, seed.input=NULL)}
\arguments{
  \item{P.pars}{Parameters for prosecution hypothesis, as generated by optimisation.params.}
\item{D.pars}{Parameters for prosecution hypothesis, as generated by optimisation.params.}
\item{tolerance}{Tolerance for the final chunk of optimisation. If the relative difference 
between the current result, and the last checked result is less than this value, then it is 
classed as converged.}
\item{n.steps}{Number of steps to run. Defaults to NULL. if n.steps is NULL , the number
 of steps to run is determined by the mean of the standard deviation of the initial phase of 
the intial chunk of optimisation for prosecution and defence. }
\item{progBar}{Logical, stating whether to display a graphical progress basr or not. This should
be set to FALSE is the user does not have graphical capabilities e.g. if running from command
line on a server.}
\item{interim}{Logical, stating whether or not to generate interim reports. If set to TRUE a basic 
set of results after each step is output to "Interim.csv", and an image of the content of 
evaluate() or evaluate.from.interim() "interim.RData" are both stored in the current working 
directory. The latter can be used by evaluate.from.interim() to continue an evaluation from its 
previous state. Each step will write over the results from the previous step.}
\item{CR.start}{Numerical, between 0 and 1, used by DEoptim as CR argument, at the start of the 
search. Gradually moves towards CR.end to allow a broader initial search, gradually becoming 
more localised in parameter space. See DEoptim for further details.}
\item{CR.end}{Numerical, between 0 and 1,see details for CR.start.}
\item{seed.input}{An integer that should be specified if the user wishes to set a particular seed. 
If not specified, the program sets the seed to an integer representation of the present time, date and process ID.}

}
\value{
A list containing five elements:
\item{Pros}{Prosecution results, structured as results from DEoptim::DEoptim.}
\item{Def}{Defence results, structured as results from DEoptim::DEoptim.}
\item{WoE}{WoE for each chunk. The final value if the final WoE.}
\item{seed.used}{Seed that is set at the beginning of computation.}
\item{seed.input}{Seed that is input by the user.}
} 
\description{
Optimize both prosecution and defence likelihoods, returning the weight of evidence.
}
\details{
  Optimize over parameter space, using a geometric progression of crossover rate and tolerance.
Both prosecution and defence cases are optimized simultaneously.
}
\seealso{DEoptim,DEoptimLoop}
\examples{
\dontrun{
# datapath to example files
datapath = file.path(system.file("extdata", package="likeLTD"),"hammer")

# File paths and case name for allele report
admin = pack.admin.input(
            cspFile = file.path(datapath, 'hammer-CSP.csv'),
            refFile = file.path(datapath, 'hammer-reference.csv'),
            caseName = "hammer",
	    kit= "SGMplus"
             )

# Enter arguments
args = list(
        nUnknowns = 1,
        doDropin = FALSE,
        ethnic = "EA1",
        adj = 1,
        fst = 0.02,
        relatedness = c(0,0)
        )

# Create hypotheses
hypP = do.call(prosecution.hypothesis, append(admin,args))
hypD = do.call(defence.hypothesis, append(admin,args))

# Get parameters for optimisation
paramsP = optimisation.params(hypP)
paramsD = optimisation.params(hypD)

# Run optimisation
# n.steps set for demonstration purposes
results = evaluate(paramsP, paramsD, n.steps=1)
}
}


