% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/event_operations.R
\name{crop_events}
\alias{crop_events}
\title{Crop Events}
\usage{
crop_events(e, crops, scaled.cols = NULL)
}
\arguments{
\item{e}{An event table.}

\item{crops}{An event table specifying the intervals for cropping. Point intervals are allowed, and will create new point events where they intersect the interior, but not the endpoints, of line events.}

\item{scaled.cols}{Names or indices of the columns of the event table to be rescaled after cutting (see \code{\link{cut_events}}). Names are interpreted as regular expressions (\code{\link{regex}}) matching full column names.}
}
\description{
Crops events to the specified intervals. Events are cut at interval endpoints and any whole or partial events lying outside the intervals are removed.
}
\examples{
e <- events(c(0, 10, 20), c(10, 20, 30), x = 10)
crop_events(e, events(c(0, 15)))
crop_events(e, events(c(0, 5, 15)))
crop_events(e, events(c(0, 5, 15)), scaled.cols = "x")
crop_events(e, events(c(0, 5, 5, 15)), scaled.cols = "x")   # creates new points inside lines
crop_events(e, events(c(0, 10, 10, 15)), scaled.cols = "x") # but not at line event endpoints
}
\seealso{
\code{\link{cut_events}} for only cutting events.
}

