% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_gloss_list.R
\name{make_gloss_list}
\alias{make_gloss_list}
\title{Make a gloss list}
\usage{
make_gloss_list(
  definition_source = lingglosses::glosses_df,
  remove_glosses = "",
  all_possible_variants = FALSE,
  annotate_problematic = TRUE
)
}
\arguments{
\item{definition_source}{dataframe with the columns \code{gloss} and \code{definition} that helps to automatic search for the gloss definitions.}

\item{remove_glosses}{character vector that contains glosses that should be removed from the abbreviation list.}

\item{all_possible_variants}{logical. Some glosses have multiple definitions.}

\item{annotate_problematic}{logical. Whether emphasize duplicated and definitionless glosses}
}
\value{
a string with glosses and their definitions gathered from \code{definition_source} table.
}
\description{
Creates a gloss list based on glosses used in \code{\link{gloss_example}}. This function tries to guess the meaning of used glosses based on some internal database or database provided by user. You shouldn't treat result as carved in stone: you can copy, modify and paste in your markdown document. If you want your glossing list to be created automatically with \code{make_gloss_list} you can compile your own table in the \code{definition_source} argument.
}
\author{
George Moroz <agricolamz@gmail.com>
}
