% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grassControl.R
\name{findGRASS}
\alias{findGRASS}
\title{Return attributes of valid 'GRASS GIS' installation(s) on the system}
\usage{
findGRASS(searchLocation = "default", ver_select = FALSE, quiet = TRUE)
}
\arguments{
\item{searchLocation}{location to be searched for the grass executable, 
i.e. one executable for each GRASS installation on the system.
For Windows systems
it is mandatory to include an uppercase Windows drive letter and a colon.
Default For Windows Systems 
is \code{C:}, for Linux systems default is \code{/usr/bin}.}

\item{ver_select}{boolean default is FALSE. If there is more than one 'SAGA GIS' installation and \code{ver_select} = TRUE the user can select interactively the preferred 'SAGA GIS' version}

\item{quiet}{boolean  switch for supressing console messages default is TRUE}
}
\value{
A dataframe with the 'GRASS GIS' binary folder(s) (i.e. where the 
individual GRASS commands are installed), version name(s) and 
installation type code(s)
}
\description{
Provides a list of valid 'GRASS GIS' installation(s) 
on your system. There is a major difference between osgeo4W and 
stand_alone installations. The functions tries to find all valid 
installations by analysing the calling batch scripts.
}
\examples{
\dontrun{
# find recursively all existing 'GRASS GIS' installation folders starting 
# at the default search location
findGRASS()
}
}
\author{
Chris Reudenbach
}
