% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linpk.R
\name{dose.frame}
\alias{dose.frame}
\title{Get the doses from a PK profile.}
\usage{
dose.frame(x)
}
\arguments{
\item{x}{A object of class \code{\link{pkprofile}}.}
}
\value{
A \code{data.frame} containing the realized doses, one per row. The
\code{data.frame} has all the columns described in \code{\link{pkprofile}},
except \code{addl}, since all additional doses have been expanded to
individual rows. It also has a \code{conc} column with the simulated
concentration at the time of the dose.
}
\description{
Get the doses from a PK profile.
}
\examples{
t.obs <- seq(0, 6*24, 0.5)
y <- pkprofile(t.obs, cl=0.5, vc=11, ka=1.3,
    dose=list(t.dose=c(0, 24*2 + 14), amt=c(100, 50), addl=c(4, 0), ii=24))
dose.frame(y)
}
\seealso{
\code{\link{pkprofile}}
}
