% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yoda_test_linter.R
\name{yoda_test_linter}
\alias{yoda_test_linter}
\title{Block obvious "yoda tests"}
\usage{
yoda_test_linter()
}
\description{
Yoda tests use \verb{(expected, actual)} instead of the more common \verb{(actual, expected)}.
This is not always possible to detect statically; this linter focuses on
the simple case of testing an expression against a literal value, e.g.
\verb{(1L, foo(x))} should be \verb{(foo(x), 1L)}.
}
\examples{
# will produce lints
lint(
  text = "expect_equal(2, x)",
  linters = yoda_test_linter()
)

lint(
  text = 'expect_identical("a", x)',
  linters = yoda_test_linter()
)

# okay
lint(
  text = "expect_equal(x, 2)",
  linters = yoda_test_linter()
)

lint(
  text = 'expect_identical(x, "a")',
  linters = yoda_test_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
\url{https://en.wikipedia.org/wiki/Yoda_conditions}
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=package_development_linters]{package_development}, \link[=readability_linters]{readability}
}
