% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_comparison_linter.R
\name{list_comparison_linter}
\alias{list_comparison_linter}
\title{Block usage of comparison operators with known-list() functions like lapply}
\usage{
list_comparison_linter()
}
\description{
Usage like \code{lapply(x, sum) > 10} is awkward because the list must first
be coerced to a vector for comparison. A function like \code{\link[=vapply]{vapply()}}
should be preferred.
}
\examples{
# will produce lints
lint(
  text = "lapply(x, sum) > 10",
  linters = list_comparison_linter()
)

# okay
lint(
  text = "unlist(lapply(x, sum)) > 10",
  linters = list_comparison_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=common_mistakes_linters]{common_mistakes}
}
