#' litterfitter: methods for fitting curves to litter decomposition trajectories
#'
#' @description There is a long tradition of studying the flux of carbon from 
#' the biosphere to the atmosphere by following a particular cohort of litter
#' (wood, leaves, roots, or other organic material) through time.  The 
#' resulting data are mass remaining and time.  A variety of functional forms
#' may be used to fit the resulting data.  Some work better empirically.  
#' Some are better connected to a process-based understanding.  
#' Some have a small number of free parameters; others have more. 
#' This package matches decomposition data to a set of these curves 
#' using likelihood--based fitting.
#'
#' @references Cornwell, W. K., and J. T. Weedon. (2013). Decomposition trajectories of diverse litter types: a model selection analysis. Methods in Ecology and Evolution.
#'
#' @references Manzoni, S., Pineiro, G., Jackson, R. B., Jobbagy, E. G., Kim, J. H., & Porporato, A. (2012). Analytical models of soil and litter decomposition: Solutions for mass loss and time-dependent decay rates. Soil Biology and Biochemistry, 50, 66-76.
#' 
#' @docType package
#' @name litterfitter
NULL 

