% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.lmdu.R
\name{plot.lmdu}
\alias{plot.lmdu}
\title{Plots a Logistic MDU model}
\usage{
\method{plot}{lmdu}(
  x,
  dims = c(1, 2),
  ycol = "darkgreen",
  xcol = "lightskyblue",
  ocol = "grey",
  ...
)
}
\arguments{
\item{x}{an object of type lmdu}

\item{dims}{which dimensions to visualize}

\item{ycol}{colour for representation of response variables}

\item{xcol}{colour for representation of predictor variables}

\item{ocol}{colour for representation of row objects}

\item{\dots}{additional arguments to be passed.}
}
\value{
Plot of the results obtained from lmdu
}
\description{
Plots a Logistic MDU model
}
\examples{
\dontrun{
data(dataExample_lmdu)
Y = as.matrix(dataExample_lmdu[ , 1:8])
X = as.matrix(dataExample_lmdu[ , 9:13])
# unsupervised
output = lmdu(Y = Y, S = 2)
plot(output)
}

}
