library(lme4)
data(Oxboys, package = "nlme")
m1 <- pdIdent(~ 1)
m1
## These method calls should produce error messages
try(as(m1, "pdmatrix"))
try(as(m1, "pdfactor"))
try(as(m1, "corrmatrix"))
try(pdMatrix(m1))
try(pdFactor(m1))
try(as(m1, 'matrix'))
formula(m1)
try(coef(m1))
try(corMatrix(m1))
try(dim(m1))
## Initialize the coefficients - this does not initialize the matrix
## FIXME - this assignment should produce an error
try(coef(m1) <- 0.01)
try(as(m1, "pdmatrix"))
try(as(m1, "pdfactor"))
try(as(m1, "corrmatrix"))
try(pdMatrix(m1))
try(pdFactor(m1))
try(as(m1, 'matrix'))
formula(m1)
try(coef(m1))
try(corMatrix(m1))
try(dim(m1))
## Initialize from a matrix
m2 <- pdIdent(~ 1)
as(m2, "matrix") <- crossprod(model.matrix(height ~ 1, Oxboys))
as(m2, "pdmatrix")
as(m2, "pdfactor")
as(m2, "corrmatrix")
pdMatrix(m2)
pdFactor(m2)
as(m2, 'matrix')
formula(m2)
coef(m2)
corMatrix(m2)
dim(m2)
LMEgradient(m2, A = diag(1.01, ncol = 1), nlev = 4)
EMupdate(m2, 4) <- diag(1.01, ncol = 1)
## Check for dimensions > 1
data(Machines, package = "nlme")
m3 <- pdIdent(~ Machine - 1)
as(m3, "pdmatrix") <- crossprod(model.matrix(formula(m3), Machines))
as(m3, "pdmatrix")
as(m3, "pdfactor")
as(m3, "corrmatrix")
pdMatrix(m3)
pdFactor(m3)
as(m3, 'matrix')
formula(m3)
coef(m3)
corMatrix(m3)
dim(m3)
names(m3)
Names(m3)
LMEgradient(m3, A = diag(rep(1.01, 3)), nlev = 4)
EMupdate(m3, 4) <- diag(rep(1.01, 3))
