% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simulateShares}
\alias{simulateShares}
\title{Simulate expected shares from a set of alternatives}
\usage{
simulateShares(model, alts, priceName = NULL, alpha = 0.025)
}
\arguments{
\item{model}{The output of a model estimated model using the \code{logitr()}
function.}

\item{alts}{A data frame of a set of alternatives for which to simulate
shares. Each row is an alternative and each column an attribute
corresponding to parameter names in the estimated model.}

\item{priceName}{The name of the parameter that identifies price. Only
required for WTP space models. Defaults to \code{NULL}.}

\item{alpha}{The sensitivity of the computed confidence interval, e.g. a
90\% CI is obtained with \code{alpha = 0.05}. Defaults to \code{alpha = 0.025}.}
}
\value{
A data frame with the estimated shares for each alternative in
\code{alts}.
}
\description{
Returns the expected shares of a specific set of alternatives based
on an estimated model.
}
\examples{
# Run a MNL model in the Preference Space:
library(logitr)

mnl_pref <- logitr(
  data = yogurt,
  choiceName = "choice",
  obsIDName = "obsID",
  parNames = c("price", "feat", "dannon", "hiland", "yoplait")
)

# Create a set of alternatives for which to simulate shares:
alts <- subset(yogurt, obsID == 42,
  select = c("feat", "price", "dannon", "hiland", "yoplait")
)
row.names(alts) <- c("dannon", "hiland", "weight", "yoplait")
alts

# Run the simulation using the estimated preference space MNL model:
simulateShares(mnl_pref, alts)
}
\keyword{logitr}
\keyword{simluation}
