% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{getCoefTable}
\alias{getCoefTable}
\title{Get the coefficient summary table as a data frame}
\usage{
getCoefTable(object)
}
\arguments{
\item{object}{The output of a model estimated model using the \code{logitr()}
function.}
}
\value{
Returns a data frame of the coefficient summary table of a model
estimated using the \code{logitr()} function.
}
\description{
Returns a data frame of the coefficient summary table of a model estimated
using the \code{logitr()} function.
}
\examples{
library(logitr)

# Run a MNL model in the preference space
mnl_pref <- logitr(
  data = yogurt,
  choiceName = "choice",
  obsIDName = "obsID",
  parNames = c("price", "feat", "dannon", "hiland", "yoplait")
)

# Get the coefficient summary table as a data frame
getCoefTable(mnl_pref)
}
\keyword{coefTable}
\keyword{logitr}
\keyword{summary}
