% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predictChoices}
\alias{predictChoices}
\title{Predict choices}
\usage{
predictChoices(model, alts, obsIDName = NULL)
}
\arguments{
\item{model}{The output of a model estimated model using the \code{logitr()}
function.
Include if you want to compare true choices from actual observations (e.g.
hold outs) to the predicted choices.}

\item{alts}{A data frame of a set of alternatives for which to predict
choices. Each row is an alternative and each column an attribute
corresponding to parameter names in the estimated model.}

\item{obsIDName}{The name of the column that identifies each set of
alternatives. Required if simulating results for more than one set of
alternatives. Defaults to \code{NULL} (for a single set of alternatives).}
}
\value{
A data frame with the predicted choices for each alternative in
\code{alts}.
}
\description{
Returns the expected choices for a set of one or more alternatives based
on the results from an estimated model.
}
\examples{
\dontrun{
# Run a MNL model in the Preference Space:
library(logitr)

mnl_pref <- logitr(
  data = yogurt,
  choiceName = "choice",
  obsIDName = "obsID",
  parNames = c("price", "feat", "brand")
)

# You can predict choices for any set of alternative, such as hold out
# samples or within-sample. For this example I will predict choices on
# the full yogurt data set, which was used to estimate the model.

# Run the simulation using the preference space MNL model:
choices_mnl_pref <- predictChoices(
  model      = mnl_pref,
  alts       = yogurt,
  obsIDName  = "obsID"
)

head(choices_mnl_pref)

# Compute the accuracy
chosen <-  subset(choices, choice == 1)
chosen$correct <- chosen$choice == chosen$choice_predict
sum(chosen$correct) / nrow(chosen)
}
}
\keyword{choice}
\keyword{logitr}
\keyword{predict}
\keyword{simulation}
