% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logr.R
\name{log_suspend}
\alias{log_suspend}
\title{Suspends the log}
\usage{
log_suspend()
}
\value{
None
}
\description{
The \code{log_suspend} function function suspends printing to the log, but
does not close it. The function will
not print the log footer. To reopen the log, call \code{\link{log_resume}}.
}
\examples{
library(logr)

# Create temp file location
tmp <- file.path(tempdir(), "test.log")

# Open log
lf <- log_open(tmp)

# Send message to log
log_print("Before suspend")

# Suspend log
log_suspend()

# View suspended log
writeLines(readLines(lf))

# Resume log
log_resume(lf)

# Print data to log
log_print("After suspend")

# Close log
log_close()

# View results
writeLines(readLines(lf))
}
\seealso{
\code{\link{log_resume}} to continue logging.
}
