% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{lol.sims.xor2}
\alias{lol.sims.xor2}
\title{Xor Problem}
\usage{
lol.sims.xor2(n, d, priors = NULL, fall = 100)
}
\arguments{
\item{n}{the number of samples of the simulated data.}

\item{d}{the dimensionality of the simulated data.}

\item{priors}{the priors for each class. If \code{NULL}, class priors are all equal. If not null, should be \code{|priors| = K}, a length \code{K} vector for \code{K} classes. Defaults to \code{NULL}.}

\item{fall}{the falloff for the covariance structuring. Sigma declines by ndim/fall across the variance terms. Defaults to \code{100}.}
}
\value{
A list of class \code{simulation} with the following:
\item{X}{\code{[n, d]} the \code{n} data points in \code{d} dimensions as a matrix.}
\item{Y}{\code{[n]} the \code{n} labels as an array.}
\item{mus}{\code{[d, K]} the \code{K} class means in \code{d} dimensions.}
\item{Sigmas}{\code{[d, d, K]} the \code{K} class covariance matrices in \code{d} dimensions.}
\item{priors}{\code{[K]} the priors for each of the \code{K} classes.}
\item{simtype}{The name of the simulation.}
\item{params}{Any extraneous parameters the simulation was created with.}
}
\description{
A function to simulate from the 2-class xor problem.
}
\examples{
library(lolR)
data <- lol.sims.xor2(n=200, d=30)  # 200 examples of 30 dimensions
X <- data$X; Y <- data$Y
}
\author{
Eric Bridgeford
}
