% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonparametric.R
\name{npsurv}
\alias{npsurv}
\title{Nonparametric maximum likelihood estimation for arbitrary truncation}
\usage{
npsurv(
  time,
  time2 = NULL,
  event = NULL,
  type = c("right", "left", "interval", "interval2"),
  ltrunc = NULL,
  rtrunc = NULL,
  weights = NULL,
  arguments = NULL,
  ...
)
}
\arguments{
\item{time}{excess time of the event of follow-up time, depending on the value of event}

\item{time2}{ending excess time of the interval for interval censored data only.}

\item{event}{status indicator, normally 0=alive, 1=dead. Other choices are \code{TRUE}/\code{FALSE} (\code{TRUE} for death).
For interval censored data, the status indicator is 0=right censored, 1=event at time, 2=left censored, 3=interval censored.
Although unusual, the event indicator can be omitted, in which case all subjects are assumed to have experienced an event.}

\item{type}{character string specifying the type of censoring. Possible values are "\code{right}", "\code{left}", "\code{interval}", "\code{interval2}".}

\item{ltrunc}{lower truncation limit, default to \code{NULL}}

\item{rtrunc}{upper truncation limit, default to \code{NULL}}

\item{weights}{vector of weights, default to \code{NULL} for equiweighted}

\item{arguments}{a named list specifying default arguments of the function that are common to all \code{elife} calls}

\item{...}{additional arguments passed to the functions}
}
\value{
a list with components
\itemize{
\item \code{xval}: unique ordered values of sets on which the distribution function is defined
\item \code{prob}: estimated probability of failure on intervals
\item \code{convergence}: logical; \code{TRUE} if the EM algorithm iterated until convergence
\item \code{niter}: logical; number of iterations for the EM algorithm
\item \code{cdf}: nonparametric maximum likelihood estimator of the distribution function
}
}
\description{
The syntax is reminiscent of the \link[survival]{Surv} function, with
additional vectors for left-truncation and right-truncation.
}
\note{
Contrary to the Kaplan-Meier estimator, the mass is placed in the interval
[\code{max(time), Inf}) so the resulting distribution function is not deficient.
}
\examples{
#' # Toy example with interval censoring and right censoring
# Two observations: A1: [1,3], A2: 4
# Probability of 0.5

test_simple2 <- npsurv(
  time = c(1,4),
  time2 = c(3,4),
  event = c(3,1),
  type = "interval"
)
}
\seealso{
\code{\link[survival]{Surv}}
}
