% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hu.mackey.thomas.linear.power.R
\name{hu.mackey.thomas.linear.power}
\alias{hu.mackey.thomas.linear.power}
\title{Random coefficient regression models (RCRM) sample size calculations}
\usage{
hu.mackey.thomas.linear.power(
  n = NULL,
  delta = NULL,
  power = NULL,
  t = NULL,
  lambda = 1,
  sig2.i = 0,
  cor.s.i = NULL,
  sig2.s = 0,
  sig2.e = NULL,
  p = NULL,
  sig.level = 0.05,
  alternative = c("two.sided", "one.sided"),
  tol = .Machine$double.eps^2
)
}
\arguments{
\item{n}{sample size, group 1. This formula can accommodate unbalanced
group allocation via \code{lambda}.}

\item{delta}{Effect size (absolute difference in rate of decline between tx and placebo)}

\item{power}{power}

\item{t}{Vector of visit time points (including time 0)}

\item{lambda}{allocation ratio (sample size group 1 divided by sample size group 2)}

\item{sig2.i}{Variance of random intercept}

\item{cor.s.i}{Correlation between random intercept & slope}

\item{sig2.s}{Variance of random slope}

\item{sig2.e}{Variance of pure error}

\item{p}{proportion vector for both groups; if \code{i} indexes visits, \code{p[i]} = the
proportion whose last visit was at visit \code{i} (\code{p} sums to 1)}

\item{sig.level}{type one error}

\item{alternative}{one- or two-sided test}

\item{tol}{numerical tolerance used in root finding}
}
\value{
One of the number of subject required per arm, the \code{power}, or
detectable effect size given \code{sig.level} and the other parameter estimates.
}
\description{
This function computes sample size and power needed for the random coefficient
regression models (RCRM) based on the formula from Hu, Mackey, and Thomas (2021).
The RCRM assumes that the experimental and control arms have the same
population baseline value.
}
\details{
See Hu. Mackey, and Thomas (2021) for parameter details.

See Equations (7) and (8) in Hu, Mackey, and Thomas (2021)
}
\examples{

\dontrun{
browseVignettes(package = "longpower")
}
# An Alzheimer's Disease example using ADAS-cog pilot estimates
t <- seq(0,1.5,0.25)
p <- c(rep(0, 6),1)

hu.mackey.thomas.linear.power(delta=1.5, t=t, 
  sig2.s=24, sig2.e=10, cor.s.i=0.5, p=p, power=0.80)
hu.mackey.thomas.linear.power(n=180, t=t, 
  sig2.s=24, sig2.e=10, cor.s.i=0.5, p=p, power=0.80)
hu.mackey.thomas.linear.power(n=180, delta=1.5, t=t, 
  sig2.s=24, sig2.e=10, cor.s.i=0.5, p=p)

hu.mackey.thomas.linear.power(delta=1.5, t=t, lambda=2, 
  sig2.s=24, sig2.e=10, cor.s.i=0.5, p=p, power=0.80)
hu.mackey.thomas.linear.power(n=270, t=t, lambda=2, 
  sig2.s=24, sig2.e=10, cor.s.i=0.5, p=p, power=0.80)
hu.mackey.thomas.linear.power(n=270, delta=1.5, t=t, lambda=2, 
  sig2.s=24, sig2.e=10, p=p, cor.s.i=0.5)

hu.mackey.thomas.linear.power(delta=1.5, t=t, 
  sig2.s=24, sig2.e=10, cor.s.i=0.5, p=p, power=0.80, alternative='one.sided')
hu.mackey.thomas.linear.power(n=142, t=t, 
  sig2.s=24, sig2.e=10, cor.s.i=0.5, p=p, power=0.80, alternative='one.sided')
hu.mackey.thomas.linear.power(n=142, delta=1.5, t=t, 
  sig2.s=24, sig2.e=10, cor.s.i=0.5, p=p, sig.level=0.05, alternative='one.sided')

}
\references{
Hu, N., Mackey, H., & Thomas, R. (2021). Power and sample size
for random coefficient regression models in randomized experiments with
monotone missing data. \emph{Biometrical Journal}, 63(4), 806-824.
}
\seealso{
\code{\link{lmmpower}}, \code{\link{diggle.linear.power}}, \code{\link{liu.liang.linear.power}}, \code{\link{edland.linear.power}}
}
\author{
Monarch Shah
}
