% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpdfit.R
\name{gpdfit}
\alias{gpdfit}
\title{Generalized Pareto distribution}
\usage{
gpdfit(x)
}
\arguments{
\item{x}{A numeric vector. The sample from which to estimate the parameters.}
}
\value{
A named list with components \code{k} and \code{sigma}.
}
\description{
Estimate the parameters \eqn{k} and \eqn{\sigma} of the generalized Pareto
distribution, given a sample \eqn{x}.
}
\details{
Here the parameter \eqn{k} is the negative of \eqn{k} in Zhang &
  Stephens (2009).
}
\note{
This function is primarily intended for internal use, but is exported
  so that users can call it directly if interested in PSIS for purposes other
  than \code{\link[=loo]{LOO-CV}}.
}
\references{
Zhang, J., and Stephens, M. A. (2009). A new and efficient estimation method
for the generalized Pareto distribution. \emph{Technometrics} \strong{51},
316-325.
}
\seealso{
\code{\link{psislw}}, \code{\link{pareto-k-diagnostic}},
  \code{\link{loo-package}}
}
\keyword{internal}

