% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psislw.R
\name{psislw}
\alias{psislw}
\title{Pareto smoothed importance sampling (PSIS)}
\usage{
psislw(lw, wcp = 0.2, wtrunc = 3/4, cores = getOption("loo.cores",
  parallel::detectCores()), llfun = NULL, llargs = NULL, ...)
}
\arguments{
\item{lw}{A matrix or vector of log weights. For computing LOO, \code{lw =
-log_lik}, the \emph{negative} of an \eqn{S} (simulations) by \eqn{N} (data
points) pointwise log-likelihood matrix.}

\item{wcp}{The proportion of importance weights to use for the generalized
Pareto fit. The \code{100*wcp}\% largest weights are used as the sample
from which to estimate the parameters of the generalized Pareto
distribution.}

\item{wtrunc}{For truncating very large weights to \eqn{S}^\code{wtrunc}. Set
to zero for no truncation.}

\item{cores}{The number of cores to use for parallelization. This can be set
for an entire R session by \code{options(loo.cores = NUMBER)}. The default
is \code{\link[parallel]{detectCores}}().}

\item{llfun, llargs}{See \code{\link{loo.function}}.}

\item{...}{Ignored when \code{psislw} is called directly. The \code{...} is
only used internally when \code{psislw} is called by the \code{\link{loo}}
function.}
}
\value{
A named list with components \code{lw_smooth} (modified log weights)
  and \code{pareto_k} (estimated generalized
  Pareto \link[=pareto-k-diagnostic]{shape parameter(s) k}).
}
\description{
Implementation of Pareto smoothed importance sampling, a method for
stabilizing importance weights. For full details about the algorithm see
Vehtari, Gelman and Gabry (2016a, 2016b). For diagnostics see the
\link{pareto-k-diagnostic} page.
}
\section{PSIS-LOO}{
 The distribution of the importance weights used in LOO may
  have a long right tail. We use the empirical Bayes estimate of Zhang and
  Stephens (2009) to fit a generalized Pareto distribution (gPd) to the tail
  (20\% largest importance ratios). By examining the shape parameter \eqn{k}
  of the fitted gPd, we are able to obtain sample based estimates of the
  existance of the moments (Koopman et al, 2009). This extends the diagnostic
  approach of Peruggia (1997) and Epifani et al. (2008) to be used routinely
  with importance-sampling LOO for any model with a factorizing likelihood.

  Epifani et al. (2008) show that when estimating the leave-one-out
  predictive density, the central limit theorem holds if the variance of the
  weight distribution is finite. These results can be extended using the
  generalized central limit theorem for stable distributions. Thus, even if
  the variance of the importance weight distribution is infinite, if the mean
  exists the estimate's accuracy improves when additional draws are obtained.
  When the tail of the weight distribution is long, a direct use of
  importance sampling is sensitive to one or few largest values. By fitting a
  gPd to the upper tail of the importance weights we smooth these values. The
  procedure (implemented in the \code{\link{psislw}} function) goes as
  follows:

\enumerate{
  \item Fit the gPd to the 20\% largest importance ratios \eqn{r_s}. The
  computation is done separately for each held-out data point \eqn{i}. In
  simulation experiments with thousands and tens of thousands of draws, we
  have found that the fit is not sensitive to the specific cutoff value (for
  a consistent estimation the proportion of the samples above the cutoff
  should get smaller when the number of draws increases).

  \item Stabilize the importance ratios by replacing the \eqn{M} largest
  ratios by the expected values of the order statistics of the fitted
  gPd \deqn{G((z - 0.5)/M), z = 1,...,M,} where
  \eqn{M} is the number of simulation draws used to fit the Pareto (in this
  case, \eqn{M = 0.2*S}) and \eqn{G} is the inverse-CDF of the gPd.

  \item To guarantee finite variance of the estimate, truncate the smoothed
  ratios with \deqn{S^{3/4}\bar{w},} where \eqn{\bar{w}} is the average of
  the smoothed weights.
}

The above steps must be performed for each data point \eqn{i}. The result is
a vector of weights \eqn{w_{i}^{s}, s = 1,...,S}, for each \eqn{i}, which in
general should be better behaved than the raw importance ratios
\eqn{r_{i}^{s}} from which they were constructed.

The results can be then combined to compute the desired LOO estimates.
}

\references{
Vehtari, A., Gelman, A., and Gabry, J. (2016a). Practical
  Bayesian model evaluation using leave-one-out cross-validation and WAIC.
  \emph{Statistics and Computing}. Advance online publication.
  doi:10.1007/s11222-016-9696-4.
  (\href{http://link.springer.com/article/10.1007\%2Fs11222-016-9696-4}{published
  version}, \href{http://arxiv.org/abs/1507.04544}{arXiv preprint}).

Vehtari, A., Gelman, A., and Gabry, J. (2016b). Pareto smoothed
  importance sampling. arXiv preprint: \url{http://arxiv.org/abs/1507.02646/}
}
\seealso{
\code{\link{pareto-k-diagnostic}} for PSIS diagnostics.
}
