% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookoutliers.R
\name{lookout}
\alias{lookout}
\title{Identifies outliers using the algorithm lookout.}
\usage{
lookout(X, alpha = 0.05, unitize = TRUE, bw = NULL, gpd = NULL)
}
\arguments{
\item{X}{The input data in a dataframe, matrix or tibble format.}

\item{alpha}{The level of significance. Default is \code{0.0.05}.}

\item{unitize}{An option to normalize the data. Default is \code{TRUE},
which normalizes each column to \code{[0,1]}.}

\item{bw}{Bandwidth parameter. Default is \code{NULL} as the bandwidth is
found using Persistent Homology.}

\item{gpd}{Generalized Pareto distribution parameters. If `NULL` (the
default), these are estimated from the data.}
}
\value{
A list with the following components:
\item{\code{outliers}}{The set of outliers.}
\item{\code{outlier_probability}}{The GPD probability of the data.}
\item{\code{bandwidth}}{The bandwdith selected using persistent homology. }
\item{\code{kde}}{The kernel density estimate values.}
\item{\code{lookde}}{The leave-one-out kde values.}
\item{\code{gpd}}{The fitted GPD parameters.}
}
\description{
This function identifies outliers using the algorithm lookout, an outlier
detection method that uses leave-one-out kernel density estimates and
generalized Pareto distributions to find outliers.
}
\examples{
X <- rbind(
  data.frame(x = rnorm(500),
             y = rnorm(500)),
  data.frame(x = rnorm(5, mean = 10, sd = 0.2),
             y = rnorm(5, mean = 10, sd = 0.2))
)
lo <- lookout(X)
lo
autoplot(lo)
}
