% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive-ggproto.R
\name{interactivity}
\alias{interactivity}
\title{Modify the \code{interactivity} component}
\usage{
interactivity(
  linkingGroup = NULL,
  linkingKey = NULL,
  linkedStates = NULL,
  sync = NULL,
  active = NULL,
  activeGeomLayers = NULL,
  selected = NULL,
  selectBy = NULL,
  selectionLogic = NULL,
  layerId = NULL,
  scaleToFun = NULL,
  itemLabel = NULL,
  showItemLabels = NULL,
  ...
)
}
\arguments{
\item{linkingGroup}{A character. Plots only in the same linkingGroup can be linked}

\item{linkingKey}{LinkingKey is the key of linking. Each object in one plot has a unique linking key.
Elements in different plots are linked if they share the same linking keys.}

\item{linkedStates}{The states to be linked. It can be "color", "selected", "active", "size" and "glyph" for a `l_plot` object and
"color", "selected", "active" for a `l_hist` object.}

\item{sync}{The way to synchronize several linked plots. It can be either "pull" (default) or "push".
If the \code{sync} is "pull", the linked states (aesthetics attributes, e.g. "color", "selected", ...)
of the new plot will be pulled from the linked plots;
if the \code{sync} is "push",  the linked states of the new plot will be pushed to the linked plots.}

\item{active}{a logical determining whether points appear or
not (default is \code{TRUE} for all points). If a logical vector is
given of length equal to the number of points,
then it identifies which points appear (\code{TRUE}) and
which do not (\code{FALSE}).}

\item{activeGeomLayers}{determine which geom layer is interactive. Only \code{geom_point()}
and \code{geom_histogram()} can be set as active geom layer(s) so far.
(Notice, more than one \code{geom_point()} layers can be set as active layers,
but only one \code{geom_histogram()} can be set as an active geom layer)}

\item{selected}{A logical vector. If it is set as \code{TRUE}, the elements are highlighted
as the graphics are constructed. Default is \code{FALSE}}

\item{selectBy}{Select by "sweeping" (default) or "brushing".}

\item{selectionLogic}{Selection logic. One of "select" (default), "deselect" and "invert". See details.}

\item{layerId}{numerical; which layer to scale to}

\item{scaleToFun}{scale to function. See \code{\link{zoom}}.}

\item{itemLabel}{The customized querying information.}

\item{showItemLabels}{A logical value. Show item labels or not. Default is \code{FALSE}}

\item{...}{named arguments to modify \code{loon} plot states. See \code{\link{l_info_states}}}
}
\value{
a \code{ggproto} object
}
\description{
Set interactive components (e.g. \code{linking}, \code{selection}, etc)
}
\details{
In interactive graphics, there are several fundamental infrastructures, such as querying, linking and selection.
Component \code{interactivity} is used to set these features.
\tabular{lll}{ \strong{Interactivity} \tab \strong{Description} \tab \strong{Subfunction}\cr
  Linking \tab Linking several plots to discover the pattern of interest \tab \code{\link{linking}}\cr
  Selection \tab Highlight the subset of interest \tab \code{\link{selection}}\cr
  Active \tab Determine which points appear \tab \code{\link{active}}\cr
  Hover \tab Query in interactive graphics \tab \code{\link{hover}}\cr
  Zoom \tab Region Modification \tab \code{\link{zoom}}\cr}
}
\examples{
if(interactive()) {
  # Modify the 'linkingGroup' and 'origin' of a hist object
  l_ggplot(mtcars, mapping = aes(x = wt)) +
    geom_histogram() +
    interactivity(linkingGroup = "mt", origin = 2)

  # linking with the histogram
  l_ggplot(mtcars, mapping = aes(x = wt, y = hp)) +
    geom_point(size = 4) +
    interactivity(linkingGroup = "mt") +
    facet_wrap(~cyl)

  p <- ggplot(economics_long, aes(value)) +
         facet_wrap(~variable, scales = 'free_x') +
         geom_histogram()
  # `p` is a ggplot object
  p
  # turn static `ggplot` to interactive `loon`
  p + interactivity()
}
}
