% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer_trails.R
\name{l_layer_trails}
\alias{l_layer_trails}
\title{Display tour path with trails}
\usage{
l_layer_trails(
  widget,
  x,
  y,
  xpre,
  ypre,
  color = "black",
  linewidth = 1,
  label = "trails",
  parent = "root",
  index = 0,
  active = TRUE,
  ...
)
}
\arguments{
\item{widget}{`loon` widget path name as a string}

\item{x}{The coordinates of x representing the current state}

\item{y}{The coordinates of y representing the current state}

\item{xpre}{the same length of \code{x} representing the last state}

\item{ypre}{the same length of \code{y} representing the last state}

\item{color}{the color of the trail}

\item{linewidth}{the line width}

\item{label}{label used in the layers inspector}

\item{parent}{parent group layer}

\item{index}{of the newly added layer in its parent group}

\item{active}{a logical determining whether points appear or not (default is \code{TRUE} for all points).
If a logical vector is given of length equal to the number of points,
then it identifies which points appear (\code{TRUE}) and which do not (\code{FALSE}).}

\item{...}{other arguments to modify \code{l_layer_line}.}
}
\value{
an \code{l_layer} widget
}
\description{
A 2D tour path with trails
}
\examples{
if(interactive()) {
p <- l_tour(iris[, -5], color = iris$Species)
l <- l_layer_trails(p, color = "grey50")
}
}
