% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer.R
\name{l_layer_text}
\alias{l_layer_text}
\title{Layer a text}
\usage{
l_layer_text(widget, x, y, text, color = "gray60", size = 6,
  angle = 0, label = "text", parent = "root", index = 0, ...)
}
\arguments{
\item{widget}{widget path name as a string}

\item{x}{coordinate}

\item{y}{coordinate}

\item{text}{character string}

\item{color}{color of text}

\item{size}{size of the font}

\item{angle}{rotation of text}

\item{label}{label used in the layers inspector}

\item{parent}{group layer}

\item{index}{of the newly added layer in its parent group}

\item{...}{additional state initialization arguments, see 
\code{\link{l_info_states}}}
}
\value{
layer object handle, layer id
}
\description{
Loon's displays that are based on Cartesian coordinates (i.e.
  scatterplot, histogram and graph display) allow for layering visual
  information including polygons, text and rectangles.

layer a single character string
}
\details{
As a side effect of \code{Tcl}'s text-based design, it is best to
  use \code{l_layer_text} if one would like to layer a single character
  string (and not \code{\link{l_layer_texts}} with \code{n=1}).

For more information run: \code{l_help("learn_R_layer")}
}
\examples{
p <- l_plot()
l <- l_layer_text(p, 0, 0, "Hello World")
}
\seealso{
\code{\link{l_layer}}, \code{\link{l_info_states}}
}
