% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scagnostics2d.R
\name{scagnostics2d}
\alias{scagnostics2d}
\title{Closure of Two Dimensional Scagnostic Measures}
\usage{
scagnostics2d(
  data,
  scagnostics = c("Clumpy", "Monotonic", "Convex", "Stringy", "Skinny", "Outlying",
    "Sparse", "Striated", "Skewed"),
  separator = ":"
)
}
\arguments{
\item{data}{a data.frame with the data used to calculate the measures}

\item{scagnostics}{vector with valid scanostics meausure names, i.e "Clumpy",
"Monotonic", "Convex", "Stringy", "Skinny", "Outlying", "Sparse", 
"Striated", "Skewed". Also the prefix "Not" can be added to each measure
which equals 1-measure.}

\item{separator}{string the separates variable names in 2d graph nodes}
}
\value{
a measures object
}
\description{
Function creates a 2d measures object that can be used with 
  \code{\link{l_ng_plots}} and \code{\link{l_ng_ranges}}.
}
\details{
For more information run: \code{l_help("learn_R_display_graph.html#measures")}
}
\examples{
\dontrun{
m <- scagnostics2d(oliveAcids, separator='**')
m
m()
m(olive$palmitoleic > 80)
m('data')
m('grid')
m('measures')
}
}
\seealso{
\code{\link{l_ng_plots}}, \code{\link{l_ng_ranges}}, 
  \code{\link{measures2d}}
}
