% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpdensity.plot.R
\name{lpdensity.plot}
\alias{lpdensity.plot}
\title{Local Polynomial Density Plot with Robust Confidence Intervals}
\usage{
lpdensity.plot(..., alpha = NULL, type = NULL, CItype = NULL,
  title = "", xlabel = "", ylabel = "", lty = NULL, lwd = NULL,
  lcol = NULL, pty = NULL, pwd = NULL, pcol = NULL,
  CIshade = NULL, CIcol = NULL, legendTitle = NULL,
  legendGroups = NULL)
}
\arguments{
\item{...}{Objects returned by \code{\link{lpdensity}}.}

\item{alpha}{Numeric scalar between 0 and 1, the significance level for plotting
confidence regions. If more than one is provided, they will be applied to data series
accordingly.}

\item{type}{String, one of \code{"line"} (default), \code{"points"} or \code{"both"}, how
the point estimates are plotted. If more than one is provided, they will be applied to data series
accordingly.}

\item{CItype}{String, one of \code{"region"} (shaded region, default), \code{"line"} (dashed lines),
\code{"ebar"} (error bars), \code{"all"} (all of the previous) or \code{"none"} (no confidence region),
how the confidence region should be plotted. If more than one is provided, they will be applied to data series
accordingly.}

\item{title, xlabel, ylabel}{Strings, title of the plot and labels for x- and y-axis.}

\item{lty}{Line type for point estimates, only effective if \code{type} is \code{"line"} or
\code{"both"}. \code{1} for solid line, \code{2} for dashed line, \code{3} for dotted line.
For other options, see the instructions for \code{\link{ggplot2}} or \code{\link{par}}. If
more than one is provided, they will be applied to data series accordingly.}

\item{lwd}{Line width for point estimates, only effective if \code{type} is \code{"line"} or
\code{"both"}. Should be strictly positive. For other options, see the instructions for
\code{\link{ggplot2}} or \code{\link{par}}. If more than one is provided, they will be applied
to data series accordingly.}

\item{lcol}{Line color for point estimates, only effective if \code{type} is \code{"line"} or
\code{"both"}. \code{1} for black, \code{2} for red, \code{3} for green, \code{4} for blue.
For other options, see the instructions for \code{\link{ggplot2}} or \code{\link{par}}. If
more than one is provided, they will be applied to data series
accordingly.}

\item{pty}{Scatter plot type for point estimates, only effective if \code{type} is \code{"points"} or
\code{"both"}. For options, see the instructions for \code{\link{ggplot2}} or \code{\link{par}}. If
more than one is provided, they will be applied to data series
accordingly.}

\item{pwd}{Scatter plot size for point estimates, only effective if \code{type} is \code{"points"} or
\code{"both"}. Should be strictly positive. If more than one is provided, they will be applied to data series
accordingly.}

\item{pcol}{Scatter plot color for point estimates, only effective if \code{type} is \code{"points"} or
\code{"both"}. \code{1} for black, \code{2} for red, \code{3}
for green, \code{4} for blue.
For other options, see the instructions for \code{\link{ggplot2}} or \code{\link{par}}. If
more than one is provided, they will be applied to data series
accordingly.}

\item{CIshade}{Numeric, opaqueness of the confidence region, should be between 0 (transparent) and
1. Default is 0.2. If more than one is provided, they will be applied to data series
accordingly.}

\item{CIcol}{color for confidence region. \code{1} for black, \code{2} for red, \code{3}
for green, \code{4} for blue.
For other options, see the instructions for \code{\link{ggplot2}} or \code{\link{par}}. If
more than one is provided, they will be applied to data series
accordingly.}

\item{legendTitle}{String, title of legend.}

\item{legendGroups}{String Vector, group names used in legend.}
}
\value{
\item{}{A stadnard \code{ggplot} object is returned, hence can be used for further customization.}
}
\description{
\code{lpdensity.plot} plots estimated density/derivatives. This command
  can also be used to plot smoothed distribution function. See
  \href{https://sites.google.com/site/nppackages/lpdensity/Cattaneo-Jansson-Ma_2019_lpdensity.pdf?attredirects=0}{Cattaneo, Jansson and Ma (2019b)} for more implementation details and illustrations.

  Companion command: \code{\link{lpdensity}} for local polynomial based density
  and derivatives estimation.

  For more details, and related Stata and R packages useful for empirical analysis,
  visit \url{https://sites.google.com/site/nppackages/}.
}
\examples{
set.seed(42); X <- rnorm(2000)

X <- X - 0.5; X[X>0] <- X[X>0] * 2
est1 <- lpdensity(data = X[X<=0], grid = seq(-2.5, 0, 0.05), bwselect = "IMSE",
  scale = sum(X<=0)/length(X))
est2 <- lpdensity(data = X[X>0],  grid = seq(0, 2, 0.05), bwselect = "IMSE",
  scale = sum(X>0)/length(X))
lpdensity.plot(est1, est2, legendTitle="My Plot", legendGroups=c("Left", "Right"))

}
\references{
M. D. Cattaneo, M. Jansson and X. Ma. (2019a). \href{https://arxiv.org/abs/1811.11512}{Simple Local Polynomial Density Estimators}. Working paper.

M. D. Cattaneo, M. Jansson and X. Ma. (2019b). \href{https://sites.google.com/site/nppackages/lpdensity/Cattaneo-Jansson-Ma_2019_lpdensity.pdf?attredirects=0}{\code{lpdensity}: Local Polynomial Density Estimation and Inference}. Working paper.
}
\seealso{
\code{\link{lpdensity}}
}
\author{
Matias D. Cattaneo, University of Michigan. \email{cattaneo@umich.edu}.

Michael Jansson, University of California, Berkeley. \email{mjansson@econ.berkeley.edu}.

Xinwei Ma (maintainer), University of Michigan. \email{xinweima@umich.edu}.
}
