# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Log-rank test simulation
#' @description Performs simulation for two-arm group sequential
#' trials based on weighted log-rank test.
#'
#' @inheritParams param_kMax
#' @param informationTime Information time in terms of variance of
#'   weighted log-rank test score statistic under the null hypothesis.
#'   Same as informationRates in terms of number of events for
#'   the conventional log-rank test. Use \code{caltime} and \code{lrstat}
#'   to derive the information time for weighted log-rank tests.
#'   Fixed prior to the trial. Defaults to
#'   \code{plannedEvents / sum(plannedEvents)} if left unspecified.
#' @inheritParams param_criticalValues
#' @inheritParams param_futilityBounds
#' @inheritParams param_hazardRatioH0
#' @param allocation1 Number of subjects in the active treatment group in
#'   a randomization block. Defaults to 1 for equal randomization.
#' @param allocation2 Number of subjects in the control group in
#'   a randomization block. Defaults to 1 for equal randomization.
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1_stratified
#' @inheritParams param_gamma2_stratified
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @param plannedEvents The planned cumulative total number of events at each
#'   stage.
#' @param plannedTime The planned analysis time for each stage needed for  
#'   analyses planned at calendar times, in which case, plannedEvents should 
#'   be missing.
#' @param maxNumberOfIterations The number of simulation iterations.
#'   Defaults to 1000.
#' @param maxNumberOfRawDatasetsPerStage The number of raw datasets per stage
#'   to extract. Defaults to 1.
#' @param seed The seed to reproduce the simulation results.
#'   The computer clock will be used if left unspecified,
#'
#' @return A list of S3 class \code{lrsim} with 3 components:
#'
#' * \code{overview} is a list of containing incremental and cumulative
#' efficacy and futility stopping probabilities by stage, expected number
#' of events, number of dropouts, number of subjects, and analysis time
#' by stage, overall rejection probability, overall expected number of
#' events, number of dropouts, number of subjects, and study duration,
#' the hazard ratio under H0, and whether the analyses are planned 
#' based on the number of events or calendar time.
#'
#' * \code{sumdata} is a data frame of summary data by stage for each
#' iteration, containing at which stage the trial stops, whether the target
#' number of events is achieved, the analysis time, number of accrued
#' subjects overall and by treatment group, number of events overall and by
#' treatment group, number of dropouts overall and by treatment group,
#' numerator and variance of weighted log-rank score statistic, log-rank
#' test Z-statistic, and whether the trial stops for efficacy or futility
#' at the stage.
#'
#'
#' * \code{rawdata} (exists if \code{maxNumberOfRawDatasetsPerStage} is a
#' positive integer) is a data frame for subject-level data for selected
#' replications, containing the subject number, arrival time, stratum,
#' treatment group, survival time, dropout time, observation time when
#' the trial stops, time under observation, and event and dropout
#' indicators.
#'
#' @examples
#' # Example 1: analyses based on number of events
#' 
#' sim1 = lrsim(kMax = 2, informationTime = c(0.5, 1),
#'              criticalValues = c(2.797, 1.977),
#'              accrualIntensity = 11,
#'              lambda1 = 0.018, lambda2 = 0.030,
#'              accrualDuration = 12,
#'              plannedEvents = c(60, 120),
#'              maxNumberOfIterations = 1000,
#'              maxNumberOfRawDatasetsPerStage = 1,
#'              seed = 314159)
#'
#' # summary statistics
#' sim1
#'
#' # summary for each simulated data set
#' head(sim1$sumdata)
#'
#' # raw data for selected replication
#' head(sim1$rawdata)
#'
#'
#' # Example 2: analyses based on calendar time have similar power
#'
#' sim2 = lrsim(kMax = 2, informationTime = c(0.5, 1),
#'              criticalValues = c(2.797, 1.977),
#'              accrualIntensity = 11,
#'              lambda1 = 0.018, lambda2 = 0.030,
#'              accrualDuration = 12,
#'              plannedTime = c(31.9, 113.2),
#'              maxNumberOfIterations = 1000,
#'              maxNumberOfRawDatasetsPerStage = 1,
#'              seed = 314159)
#'
#' # summary statistics
#' sim2
#'
#' # summary for each simulated data set
#' head(sim2$sumdata)
#' 
#' @export
lrsim <- function(kMax = NA_integer_, informationTime = NA_real_, criticalValues = NA_real_, futilityBounds = NA_real_, hazardRatioH0 = 1, allocation1 = 1L, allocation2 = 1L, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, rho1 = 0, rho2 = 0, plannedEvents = NA_integer_, plannedTime = NA_real_, maxNumberOfIterations = 1000L, maxNumberOfRawDatasetsPerStage = 0L, seed = NA_integer_) {
    .Call(`_lrstat_lrsim`, kMax, informationTime, criticalValues, futilityBounds, hazardRatioH0, allocation1, allocation2, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, plannedEvents, plannedTime, maxNumberOfIterations, maxNumberOfRawDatasetsPerStage, seed)
}

#' @title Number of enrolled subjects
#' @description Obtains the number of subjects enrolled by given calendar
#' times.
#'
#' @param time A vector of calendar times at which to calculate the number
#' of enrolled subjects.
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_accrualDuration
#'
#' @return A vector of total number of subjects enrolled by the
#' specified calendar times.
#'
#' @examples
#' # Example 1: Uniform enrollment with 20 patients per month for 12 months.
#'
#' accrual(time = 3, accrualTime = 0, accrualIntensity = 20,
#'         accrualDuration = 12)
#'
#'
#' # Example 2: Piecewise accrual, 10 patients per month for the first
#' # 3 months, and 20 patients per month thereafter. Patient recruitment
#' # ends at 12 months for the study.
#'
#' accrual(time = c(2, 9), accrualTime = c(0, 3),
#'         accrualIntensity = c(10, 20), accrualDuration = 12)
#'
#' @export
accrual <- function(time = NA_real_, accrualTime = 0L, accrualIntensity = NA_real_, accrualDuration = NA_real_) {
    .Call(`_lrstat_accrual`, time, accrualTime, accrualIntensity, accrualDuration)
}

#' @title Probability of being at risk
#' @description Obtains the probability of being at risk at given analysis
#' times.
#'
#' @param time A vector of analysis times at which to calculate the
#' probability of being at risk.
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda
#' @inheritParams param_gamma
#'
#' @return A vector of probabilities of being at risk at the specified
#' analysis times after enrollment for a patient in a treatment group with
#' specified piecewise exponential survival and dropout distributions.
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise exponential survival with hazard 0.0533 in the first 6 months,
#' # and hazard 0.0309 thereafter, and 5% dropout by the end of 1 year.
#'
#' patrisk(time = c(3, 9), piecewiseSurvivalTime = c(0, 6),
#'         lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)
#'
#' @export
patrisk <- function(time = NA_real_, piecewiseSurvivalTime = 0L, lambda = NA_real_, gamma = 0L) {
    .Call(`_lrstat_patrisk`, time, piecewiseSurvivalTime, lambda, gamma)
}

#' @title Probability of having an event
#' @description Obtains the probability of having an event at given analysis
#' times.
#'
#' @param time A vector of analysis times at which to calculate the
#' probability of having an event.
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda
#' @inheritParams param_gamma
#'
#' @return A vector of probabilities of having an event at the specified
#' analysis times after enrollment for a patient in a treatment group with
#' specified piecewise exponential survival and dropout distributions.
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise exponential survival with hazard 0.0533 in the first 6 months,
#' # and hazard 0.0309 thereafter, and 5% dropout by the end of 1 year.
#'
#' pevent(time = c(3, 9), piecewiseSurvivalTime = c(0, 6),
#'        lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)
#'
#' @export
pevent <- function(time = NA_real_, piecewiseSurvivalTime = 0L, lambda = NA_real_, gamma = 0L) {
    .Call(`_lrstat_pevent`, time, piecewiseSurvivalTime, lambda, gamma)
}

#' @title Integrated event probability over an interval with constant hazard
#' @description Obtains the integration probability of having an event
#' during an interval with constant hazard.
#'
#' @param j The analysis time interval with constant hazard.
#' @param t1 Lower bound of the analysis time interval.
#' @param t2 Upper bound of the analysis time interval.
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda
#' @inheritParams param_gamma
#'
#' @return A value for the integrated probability of having an event
#' during an interval with constant hazard for a treatment
#' group with specified piecewise exponential survival and dropout
#' distributions.
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise exponential survival with hazard 0.0533 in the first 6 months,
#' # and hazard 0.0309 thereafter, and 5% dropout by the end of 1 year.
#'
#' hd(j = 1, t1 = 1, t2 = 3, piecewiseSurvivalTime = c(0, 6),
#'    lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)
#'
#' @export
hd <- function(j = NA_integer_, t1 = NA_real_, t2 = NA_real_, piecewiseSurvivalTime = 0L, lambda = NA_real_, gamma = 0L) {
    .Call(`_lrstat_hd`, j, t1, t2, piecewiseSurvivalTime, lambda, gamma)
}

#' @title Integrated event probability over an interval
#' @description Obtains the integration of the probability of having an event
#' during an interval. The specified analysis time interval can span more
#' than one analysis time interval with constant hazard.
#'
#' @param t1 Lower bound of the analysis time interval.
#' @param t2 Upper bound of the analysis time interval.
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda
#' @inheritParams param_gamma
#'
#' @return A value for the integrated probability of having an event
#' during an interval for a treatment group with specified
#' piecewise exponential survival and dropout distributions.
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise exponential survival with hazard 0.0533 in the first 6 months,
#' # and hazard 0.0309 thereafter, and 5% dropout by the end of 1 year.
#'
#' pd(t1 = 1, t2 = 8, piecewiseSurvivalTime = c(0, 6),
#'    lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)
#'
#' @export
pd <- function(t1 = NA_real_, t2 = NA_real_, piecewiseSurvivalTime = 0L, lambda = NA_real_, gamma = 0L) {
    .Call(`_lrstat_pd`, t1, t2, piecewiseSurvivalTime, lambda, gamma)
}

#' @title Number of patients enrolled during an interval and having an event
#' by specified calendar times
#' @description Obtains the number of patients who are enrolled during a
#' specified enrollment time interval and have an event by the specified
#' calendar times.
#'
#' @param time A vector of calendar times at which to calculate the number
#' of patients having an event.
#' @param u1 Lower bound of the accrual time interval.
#' @param u2 Upper bound of the accrual time interval.
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda
#' @inheritParams param_gamma
#'
#' @return A vector of number of patients who are enrolled during a
#' specified enrollment time interval and have an event by the specified
#' calendar times for a given treatment group had the enrollment being
#' restricted to the treatment group. By definition, we must have
#' \code{time >= u2}.
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise accrual, 10 patients per month for the first 3 months, and
#' # 20 patients per month thereafter. Piecewise exponential survival with
#' # hazard 0.0533 in the first 6 months, and hazard 0.0309 thereafter,
#' # and 5% dropout by the end of 1 year.
#'
#' ad(time = c(9, 15), u1 = 1, u2 = 8, accrualTime = c(0, 3),
#'    accrualIntensity = c(10, 20), piecewiseSurvivalTime=c(0, 6),
#'    lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)
#'
#' @export
ad <- function(time = NA_real_, u1 = NA_real_, u2 = NA_real_, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, lambda = NA_real_, gamma = 0L) {
    .Call(`_lrstat_ad`, time, u1, u2, accrualTime, accrualIntensity, piecewiseSurvivalTime, lambda, gamma)
}

#' @title Number of subjects at risk
#' @description Obtains the number of subjects at risk at given analysis
#' times for each treatment group.
#'
#' @param time A vector of analysis times at which to calculate the number
#' of patients at risk.
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda1
#' @inheritParams param_lambda2
#' @inheritParams param_gamma1
#' @inheritParams param_gamma2
#' @inheritParams param_accrualDuration
#' @inheritParams param_minFollowupTime
#' @inheritParams param_maxFollowupTime
#'
#' @return A matrix of the number of patients at risk at the specified
#' analysis times for each treatment group.
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' natrisk(time = c(9, 24), allocationRatioPlanned = 1,
#'         accrualTime = c(0, 3), accrualIntensity = c(10, 20),
#'         piecewiseSurvivalTime = c(0, 6),
#'         lambda1 = c(0.0533, 0.0309), lambda2 = c(0.0533, 0.0533),
#'         gamma1 = -log(1-0.05)/12, gamma2 = -log(1-0.05)/12,
#'         accrualDuration = 12, minFollowupTime = 18,
#'         maxFollowupTime = 30)
#'
#' @export
natrisk <- function(time = NA_real_, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, minFollowupTime = NA_real_, maxFollowupTime = NA_real_) {
    .Call(`_lrstat_natrisk`, time, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, lambda1, lambda2, gamma1, gamma2, accrualDuration, minFollowupTime, maxFollowupTime)
}

#' @title Number of subjects having an event
#' @description Obtains the number of subjects having an event by given
#' analysis times for each treatment group.
#'
#' @param time A vector of analysis times at which to calculate the number
#' of patients having an event.
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda1
#' @inheritParams param_lambda2
#' @inheritParams param_gamma1
#' @inheritParams param_gamma2
#' @inheritParams param_accrualDuration
#' @inheritParams param_minFollowupTime
#' @inheritParams param_maxFollowupTime
#'
#' @return A matrix of the number of patients having an event at the specified
#' analysis times for each treatment group.
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' nevent(time = c(9, 24), allocationRatioPlanned = 1,
#'        accrualTime = c(0, 3), accrualIntensity = c(10, 20),
#'        piecewiseSurvivalTime = c(0, 6),
#'        lambda1 = c(0.0533, 0.0309), lambda2 = c(0.0533, 0.0533),
#'        gamma1 = -log(1-0.05)/12, gamma2 = -log(1-0.05)/12,
#'        accrualDuration = 12, minFollowupTime = 18,
#'        maxFollowupTime = 30)
#'
#' @export
nevent <- function(time = NA_real_, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, minFollowupTime = NA_real_, maxFollowupTime = NA_real_) {
    .Call(`_lrstat_nevent`, time, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, lambda1, lambda2, gamma1, gamma2, accrualDuration, minFollowupTime, maxFollowupTime)
}

#' @title Number of subjects having an event by calendar time
#' @description Obtains the number of subjects having an event by given
#' calendar times for each treatment group.
#'
#' @param time A vector of calendar times at which to calculate the number
#' of patients having an event.
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda1
#' @inheritParams param_lambda2
#' @inheritParams param_gamma1
#' @inheritParams param_gamma2
#' @inheritParams param_accrualDuration
#' @inheritParams param_minFollowupTime
#' @inheritParams param_maxFollowupTime
#'
#' @return A matrix of the number of patients having an event at the specified
#' calendar times for each treatment group.
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#' nevent2(time = c(9, 24), allocationRatioPlanned = 1,
#'         accrualTime = c(0, 3), accrualIntensity = c(10, 20),
#'         piecewiseSurvivalTime = c(0, 6),
#'         lambda1 = c(0.0533, 0.0309), lambda2 = c(0.0533, 0.0533),
#'         gamma1 = -log(1-0.05)/12, gamma2 = -log(1-0.05)/12,
#'         accrualDuration = 12, minFollowupTime = 18,
#'         maxFollowupTime = 30)
#'
#' @export
nevent2 <- function(time = NA_real_, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, minFollowupTime = NA_real_, maxFollowupTime = NA_real_) {
    .Call(`_lrstat_nevent2`, time, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, lambda1, lambda2, gamma1, gamma2, accrualDuration, minFollowupTime, maxFollowupTime)
}

#' @title Number of subjects having an event and log-rank statistic
#' for a hypothesized hazard ratio at a given calendar time
#'
#' @description Obtains the number of subjects having an event in each
#' treatment group by stratum, the mean and variance of weighted log-rank
#' score statistic for a hypothesized hazard ratio at a given calendar time.
#'
#' @param time The calendar time at which to calculate the number
#'  of events and the mean and variance of log-rank test score statistic.
#' @inheritParams param_hazardRatioH0
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1_stratified
#' @inheritParams param_gamma2_stratified
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @inheritParams param_numSubintervals
#' @param predictEventOnly Whether to predict the number of events only.
#'  Defaults to 0 for obtaining log-rank test score statistic mean
#'  and variance.
#'
#' @return A data frame of the number of subjects enrolled, the number of
#' subjects having an event overall and in each group, the number of
#' subjects who drop out overall and in each group, the mean and
#' variance of weighted log-rank score statistic at the specified
#' calendar time by stratum.
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' lrstat1(time = 22, hazardRatioH0 = 1,
#'         allocationRatioPlanned = 1,
#'         accrualTime = seq(0, 9),
#'         accrualIntensity = c(26/9*seq(1, 9), 26),
#'         piecewiseSurvivalTime = c(0, 6),
#'         stratumFraction = c(0.2, 0.8),
#'         lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'         lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'         gamma1 = -log(1-0.05)/12,
#'         gamma2 = -log(1-0.05)/12,
#'         accrualDuration = 22,
#'         followupTime = 18, fixedFollowup = FALSE)
#'
#' @export
lrstat1 <- function(time = NA_real_, hazardRatioH0 = 1, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, rho1 = 0, rho2 = 0, numSubintervals = 300L, predictEventOnly = 0L) {
    .Call(`_lrstat_lrstat1`, time, hazardRatioH0, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, numSubintervals, predictEventOnly)
}

#' @title Number of subjects having an event and log-rank statistics
#' @description Obtains the number of subjects accrued, number of events and
#' number of dropouts in each group, mean and variance of weighted log-rank
#' score statistic, estimated hazard ratio from weighted Cox regression
#' and variance of log hazard ratio estimate at given calendar times.
#'
#' @param time A vector of calendar times at which to calculate the number
#'  of events and the mean and variance of log-rank test score statistic.
#' @inheritParams param_hazardRatioH0
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1_stratified
#' @inheritParams param_gamma2_stratified
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @inheritParams param_numSubintervals
#' @param predictEventOnly Whether to predict the number of events only.
#' Defaults to 0 for obtaining log-rank score statistic mean and variance.
#' Set \code{predictEventOnly = 1} for predicting the number of events only.
#' Set \code{predictEventOnly = 2} for predicting the number of events,
#' calculating the mean and variance of log-rank score statistic, and
#' calculating the estimated hazard ratio and variance of log hazard ratio.
#'
#' @return A data frame of the number of subjects enrolled, the number of
#' subjects having an event overall and in each group, the number of subjects
#' who drop out overall and in each group, the mean and variance of weighted
#' log-rank score statistic, the estimated hazard ratio from weighted Cox
#' regression, and variance of the log hazard ratio estimate at the
#' specified calendar times.
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' lrstat(time = c(22, 40), allocationRatioPlanned = 1,
#'        accrualTime = seq(0, 9),
#'        accrualIntensity = c(26/9*seq(1, 9), 26),
#'        piecewiseSurvivalTime = c(0, 6),
#'        stratumFraction = c(0.2, 0.8),
#'        lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'        lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'        gamma1 = -log(1-0.05)/12,
#'        gamma2 = -log(1-0.05)/12,
#'        accrualDuration = 22,
#'        followupTime = 18, fixedFollowup = FALSE)
#'
#' @export
lrstat <- function(time = NA_real_, hazardRatioH0 = 1, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, rho1 = 0, rho2 = 0, numSubintervals = 300L, predictEventOnly = 0L) {
    .Call(`_lrstat_lrstat`, time, hazardRatioH0, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, numSubintervals, predictEventOnly)
}

#' @title Calendar times for target number of events
#' @description Obtains the calendar times to reach the target number of
#' subjects having an event.
#'
#' @param nevents A vector of target number of events.
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1_stratified
#' @inheritParams param_gamma2_stratified
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_numSubintervals
#'
#' @return A vector of calendar times expected to yield the target
#' number of events.
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' caltime(nevents = c(24, 80), allocationRatioPlanned = 1,
#'         accrualTime = seq(0, 9),
#'         accrualIntensity = c(26/9*seq(1, 9), 26),
#'         piecewiseSurvivalTime = c(0, 6),
#'         stratumFraction = c(0.2, 0.8),
#'         lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'         lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'         gamma1 = -log(1-0.05)/12,
#'         gamma2 = -log(1-0.05)/12,
#'         accrualDuration = 22,
#'         followupTime = 18, fixedFollowup = FALSE)
#'
#' @export
caltime <- function(nevents = NA_real_, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, numSubintervals = 300L) {
    .Call(`_lrstat_caltime`, nevents, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, numSubintervals)
}

#' @title Error spending functions
#' @description Obtains the error spent at the given information fraction
#' for the specified error spending function.
#'
#' @param t Information fraction for the interim look.
#' @param error Total error to spend.
#' @param sf Spending function. One of the following: "sfOF" for
#'  O'Brien-Fleming type spending function, "sfP" for Pocock type spending
#'  function, "sfKD" for Kim & DeMets spending function, and "sfHSD" for
#'  Hwang, Shi & DeCani spending function. Defaults to "sfOF".
#' @param sfpar Parameter for the spending function. Corresponds to rho for
#'  "sfKD" and gamma for "sfHSD"
#'
#' @return A number for the error spent up to the interim look.
#'
#' @keywords internal
#'
#' @examples
#' errorSpent(t = 0.5, error = 0.025, sf = "sfOF")
#' errorSpent(t = 0.5, error = 0.025, sf = "sfHSD", sfpar = -4)
#'
#' @export
errorSpent <- function(t, error, sf = "sfOF", sfpar = NA_real_) {
    .Call(`_lrstat_errorSpent`, t, error, sf, sfpar)
}

getCriticalValues <- function(kMax = NA_integer_, informationRates = NA_real_, efficacyStopping = NA_integer_, alpha = 0.025, typeAlphaSpending = "sfOF", parameterAlphaSpending = NA_real_, userAlphaSpending = NA_real_, hazardRatioH0 = 1, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = 20L, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda2 = 0.0533, gamma1 = 0L, gamma2 = 0L, accrualDuration = 11.6, followupTime = 18, fixedFollowup = 0L, rho1 = 0, rho2 = 0, numSubintervals = 300L) {
    .Call(`_lrstat_getCriticalValues`, kMax, informationRates, efficacyStopping, alpha, typeAlphaSpending, parameterAlphaSpending, userAlphaSpending, hazardRatioH0, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, numSubintervals)
}

getCumAlphaSpent <- function(kMax = NA_integer_, informationRates = NA_real_, criticalValues = NA_real_, hazardRatioH0 = 1, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = 20L, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda2 = 0.0533, gamma1 = 0L, gamma2 = 0L, accrualDuration = 11.6, followupTime = 18, fixedFollowup = 0L, rho1 = 0, rho2 = 0, numSubintervals = 300L) {
    .Call(`_lrstat_getCumAlphaSpent`, kMax, informationRates, criticalValues, hazardRatioH0, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, numSubintervals)
}

#' @title Log-rank test power
#' @description Estimates the power, stopping probabilities, and expected
#' sample size in a two-group survival design.
#'
#' @inheritParams param_kMax
#' @inheritParams param_informationRates
#' @inheritParams param_efficacyStopping
#' @inheritParams param_futilityStopping
#' @inheritParams param_criticalValues
#' @inheritParams param_alpha
#' @inheritParams param_typeAlphaSpending
#' @inheritParams param_parameterAlphaSpending
#' @inheritParams param_userAlphaSpending
#' @inheritParams param_futilityBounds
#' @param typeBetaSpending The type of beta spending. One of the following:
#'  "sfOF" for O'Brien-Fleming type spending function, "sfP" for Pocock type
#'  spending function, "sfKD" for Kim & DeMets spending function,
#'  "sfHSD" for Hwang, Shi & DeCani spending function, and "none" for no
#'  early futility stopping. Defaults to "none".
#' @inheritParams param_parameterBetaSpending
#' @inheritParams param_hazardRatioH0
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1_stratified
#' @inheritParams param_gamma2_stratified
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @inheritParams param_numSubintervals
#' @inheritParams param_estimateHazardRatio
#' @inheritParams param_typeOfComputation
#' 
#' @return A list of S3 class \code{lrpower} with 3 components:
#'
#' * \code{overallResults} containing the overall rejection probability,
#' overall significance level, maximum and expected number of events,
#' maximum and expected number of dropouts, total and expected number
#' of subjects, maximum and expected study duration, along with
#' input parameters including accrual duration, followup duration,
#' whether a fixed follow-up is used, parameters for the FH weights,
#' allocation ratio, number of stages, and hazard ratio under H0.
#'
#' * \code{byStageResults} containing information rates, efficacy
#' and futility boundaries on the Z-scale, probability for efficacy
#' and futility stopping at the stage, cumulative probability for
#' efficacy and futility stopping by the stage, cumulative alpha spent,
#' expected number of events, number of dropouts, number of subjects,
#' and expected study time, efficacy and futility boundaries on
#' the HR scale and on the p-value scale, information for weighted
#' log-rank test, hazard ratio from weighted Cox regression, and
#' where efficacy and futility stopping are allowed by stage.
#'
#' * \code{settings} containing input parameters such as
#' alpha and beta spending function and parameter values,
#' accrual time, accrual intensity, piecewise survival time, stratum
#' fraction, and hazard rates for survival and dropout by group.
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' lrpower(kMax = 2, informationRates = c(0.8, 1),
#'         alpha = 0.025, typeAlphaSpending = "sfOF",
#'         allocationRatioPlanned = 1, accrualTime = seq(0, 9),
#'         accrualIntensity = c(26/9*seq(1, 9), 26),
#'         piecewiseSurvivalTime = c(0, 6),
#'         stratumFraction = c(0.2, 0.8),
#'         lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'         lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'         gamma1 = -log(1-0.05)/12,
#'         gamma2 = -log(1-0.05)/12, accrualDuration = 22,
#'         followupTime = 18, fixedFollowup = FALSE)
#'
#' @export
lrpower <- function(kMax = NA_integer_, informationRates = NA_real_, efficacyStopping = NA_integer_, futilityStopping = NA_integer_, criticalValues = NA_real_, alpha = 0.025, typeAlphaSpending = "sfOF", parameterAlphaSpending = NA_real_, userAlphaSpending = NA_real_, futilityBounds = NA_real_, typeBetaSpending = "none", parameterBetaSpending = NA_real_, hazardRatioH0 = 1, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = 20L, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = 0.0309, lambda2 = 0.0533, gamma1 = 0L, gamma2 = 0L, accrualDuration = 11.6, followupTime = 18, fixedFollowup = 0L, rho1 = 0, rho2 = 0, numSubintervals = 300L, estimateHazardRatio = 1L, typeOfComputation = "direct") {
    .Call(`_lrstat_lrpower`, kMax, informationRates, efficacyStopping, futilityStopping, criticalValues, alpha, typeAlphaSpending, parameterAlphaSpending, userAlphaSpending, futilityBounds, typeBetaSpending, parameterBetaSpending, hazardRatioH0, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, numSubintervals, estimateHazardRatio, typeOfComputation)
}

#' @title Log-rank test sample size
#' @description Obtains the needed accrual duration given power and
#' follow-up time, the needed follow-up time given power and
#' accrual duration, or the needed absolute accrual rates given
#' power, accrual duration, follow-up duration, and relative accrual
#' rates in a two-group survival design.
#'
#' @param beta Type II error. Defaults to 0.2.
#' @inheritParams param_kMax
#' @inheritParams param_informationRates
#' @inheritParams param_efficacyStopping
#' @inheritParams param_futilityStopping
#' @inheritParams param_criticalValues
#' @inheritParams param_alpha
#' @inheritParams param_typeAlphaSpending
#' @inheritParams param_parameterAlphaSpending
#' @inheritParams param_userAlphaSpending
#' @inheritParams param_futilityBounds
#' @inheritParams param_typeBetaSpending
#' @inheritParams param_parameterBetaSpending
#' @inheritParams param_userBetaSpending
#' @inheritParams param_hazardRatioH0
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1_stratified
#' @inheritParams param_gamma2_stratified
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @inheritParams param_numSubintervals
#' @inheritParams param_estimateHazardRatio
#' @inheritParams param_typeOfComputation
#' @param interval The interval to search for the solution of
#' accrualDuration or followupDuration. Defaults to \code{c(0.001, 240)}.
#' Adjustment may be needed for non-monotone relationship with study power.
#'
#' @return A list of S3 class \code{lrpower}.
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' # Example 1: Obtains accrual duration given power and follow-up duration
#'
#' lrsamplesize(beta = 0.2, kMax = 2,
#'              informationRates = c(0.8, 1),
#'              alpha = 0.025, typeAlphaSpending = "sfOF",
#'              accrualTime = seq(0, 9),
#'              accrualIntensity = c(26/9*seq(1, 9), 26),
#'              piecewiseSurvivalTime = c(0, 6),
#'              stratumFraction = c(0.2, 0.8),
#'              lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'              lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'              gamma1 = -log(1-0.05)/12,
#'              gamma2 = -log(1-0.05)/12,
#'              accrualDuration = NA,
#'              followupTime = 18, fixedFollowup = FALSE)
#'
#'
#' # Example 2: Obtains follow-up duration given power and accrual duration
#'
#' lrsamplesize(beta = 0.2, kMax = 2,
#'              informationRates = c(0.8, 1),
#'              alpha = 0.025, typeAlphaSpending = "sfOF",
#'              accrualTime = seq(0, 9),
#'              accrualIntensity = c(26/9*seq(1, 9), 26),
#'              piecewiseSurvivalTime = c(0, 6),
#'              stratumFraction = c(0.2, 0.8),
#'              lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'              lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'              gamma1 = -log(1-0.05)/12,
#'              gamma2 = -log(1-0.05)/12,
#'              accrualDuration = 22,
#'              followupTime = NA, fixedFollowup = FALSE)
#'
#'
#' # Example 3: Obtains absolute accrual intensity given power,
#' # accrual duration, follow-up duration, and relative accrual intensity
#'
#' lrsamplesize(beta = 0.2, kMax = 2,
#'              informationRates = c(0.8, 1),
#'              alpha = 0.025, typeAlphaSpending = "sfOF",
#'              accrualTime = seq(0, 9),
#'              accrualIntensity = c(26/9*seq(1, 9), 26),
#'              piecewiseSurvivalTime = c(0, 6),
#'              stratumFraction = c(0.2, 0.8),
#'              lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'              lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'              gamma1 = -log(1-0.05)/12,
#'              gamma2 = -log(1-0.05)/12,
#'              accrualDuration = 22,
#'              followupTime = 18, fixedFollowup = FALSE)
#'              
#'
#' # Example 4: Non-inferiority trial with fixed follow-up and 
#' # superiority alternative
#' 
#' lr <- lrsamplesize(beta = 0.1, 
#'                    kMax = 3, 
#'                    alpha = 0.025,
#'                    typeAlphaSpending = "sfOF",
#'                    hazardRatioH0 = 1.1,
#'                    accrualTime = c(0, 6),
#'                    accrualIntensity = c(1000, 1500),
#'                    lambda1 = log(2)/48*0.95,
#'                    lambda2 = log(2)/48,
#'                    gamma1 = -log(1-0.08)/12,
#'                    gamma2 = -log(1-0.08)/12,
#'                    accrualDuration = NA,
#'                    followupTime = 18,
#'                    fixedFollowup = 1)
#'                    
#' lr
#'
#' @export
lrsamplesize <- function(beta = 0.2, kMax = NA_integer_, informationRates = NA_real_, efficacyStopping = NA_integer_, futilityStopping = NA_integer_, criticalValues = NA_real_, alpha = 0.025, typeAlphaSpending = "sfOF", parameterAlphaSpending = NA_real_, userAlphaSpending = NA_real_, futilityBounds = NA_real_, typeBetaSpending = "none", parameterBetaSpending = NA_real_, userBetaSpending = NA_real_, hazardRatioH0 = 1, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = 20L, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = 0.0309, lambda2 = 0.0533, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, followupTime = 18, fixedFollowup = 0L, rho1 = 0, rho2 = 0, numSubintervals = 300L, estimateHazardRatio = 1L, typeOfComputation = "direct", interval = as.numeric( c(0.001, 240))) {
    .Call(`_lrstat_lrsamplesize`, beta, kMax, informationRates, efficacyStopping, futilityStopping, criticalValues, alpha, typeAlphaSpending, parameterAlphaSpending, userAlphaSpending, futilityBounds, typeBetaSpending, parameterBetaSpending, userBetaSpending, hazardRatioH0, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, numSubintervals, estimateHazardRatio, typeOfComputation, interval)
}

#' @title Get group sequential design
#' @description Obtains the drift parameter and stopping boundaries for a
#' generic group sequential design assuming a constant treatment effect.
#'
#' @param beta Type II error. Defaults to 0.2.
#' @inheritParams param_kMax
#' @inheritParams param_informationRates
#' @inheritParams param_efficacyStopping
#' @inheritParams param_futilityStopping
#' @inheritParams param_criticalValues
#' @inheritParams param_alpha
#' @inheritParams param_typeAlphaSpending
#' @inheritParams param_parameterAlphaSpending
#' @inheritParams param_userAlphaSpending
#' @inheritParams param_futilityBounds
#' @inheritParams param_typeBetaSpending
#' @inheritParams param_parameterBetaSpending
#' @inheritParams param_userBetaSpending
#'
#' @return A list of S3 class \code{design}.
#'
#' @examples
#'
#' getDesign(beta = 0.2,
#'           kMax = 2,
#'           informationRates = c(0.5,1),
#'           alpha = 0.025,
#'           typeAlphaSpending = "sfOF",
#'           typeBetaSpending = "sfP")
#'
#' @export
getDesign <- function(beta = 0.2, kMax = NA_integer_, informationRates = NA_real_, efficacyStopping = NA_integer_, futilityStopping = NA_integer_, criticalValues = NA_real_, alpha = 0.025, typeAlphaSpending = "sfOF", parameterAlphaSpending = NA_real_, userAlphaSpending = NA_real_, futilityBounds = NA_real_, typeBetaSpending = "none", parameterBetaSpending = NA_real_, userBetaSpending = NA_real_) {
    .Call(`_lrstat_getDesign`, beta, kMax, informationRates, efficacyStopping, futilityStopping, criticalValues, alpha, typeAlphaSpending, parameterAlphaSpending, userAlphaSpending, futilityBounds, typeBetaSpending, parameterBetaSpending, userBetaSpending)
}

#' @title Set seed
#' @description Sets the R seed in the cpp program based on set.seed() in R.
#'
#' @param seed The seed to use for generating random numbers.
#' @return No return value, called for side effects.
#'
#' @keywords internal
#'
#' @examples
#' set_seed(123)
#'
#' @export
set_seed <- function(seed) {
    invisible(.Call(`_lrstat_set_seed`, seed))
}

#' @title Sort a numeric vector
#' @description Sorts a numeric vector in the cpp program.
#'
#' @param x The numeric vector to sort.
#' @return A vector obtained after sorting the input vector.
#'
#' @keywords internal
#'
#' @examples
#' stl_sort(c(3, 4.2, 1))
#'
#' @export
stl_sort <- function(x) {
    .Call(`_lrstat_stl_sort`, x)
}

#' @title Find interval numbers of indices
#' @description The implementation of \code{findInterval()} in R from Advanced
#' R by Hadley Wickham. Given a vector of non-decreasing breakpoints in v,
#' find the interval containing each element of x; i.e., if
#' \code{i <- findInterval2(x,v)}, for each index \code{j} in \code{x},
#' v[i[j]] <= x[j] < v[i[j] + 1]
#' where v[0] := -Inf, v[N+1] := +Inf, and \code{N = length(v)}.
#'
#' @param x The numeric vector of interest.
#' @param v The vector of break points.
#' @return A vector of \code{length(x)} with values in \code{0:N} where
#'   \code{N = length(v)}.
#'
#' @keywords internal
#'
#' @examples
#' x <- 2:18
#' v <- c(5, 10, 15) # create two bins [5,10) and [10,15)
#' cbind(x, findInterval2(x, v))
#'
#' @export
findInterval2 <- function(x, v) {
    .Call(`_lrstat_findInterval2`, x, v)
}

#' @title Stagewise exit probabilities
#' @description Obtains the stagewise exit probabilities for both efficacy and
#' futility stopping.
#'
#' @param b Upper boundaries on the z-test statistic scale.
#' @param a Lower boundaries on the z-test statistic scale. Defaults to
#' \code{c(rep(-6.0, kMax-1), b[kMax])} if left unspecified, where
#' \code{kMax = length(b)}.
#' @param theta Stagewise parameter of interest, e.g., \code{-U/V} for
#' weighted log-rank test, where \code{U} is the mean and \code{V} is
#' the variance of the weighted log-rank test score statistic at each stage.
#' For proportional hazards and conventional log-rank test, use the
#' scalar input, \code{theta = -log(HR)}.
#' @param I Stagewise cumulative information, e.g., \code{V}, the variance
#' of the weighted log-rank test score statistic at each stage. For
#' conventional log-rank test, information can be approximated by
#' \code{phi*(1-phi)*D}, where \code{phi} is the probability of being
#' allocated to the active arm, and \code{D} is the total number of events at
#' each stage.
#'
#' @return A list of stagewise exit probabilities: one vector for efficacy
#' stopping probabilities, and the other vector for futility stopping
#' probabilities.
#'
#' @examples
#' exitprob(b = c(3.471, 2.454, 2.004), a = NA,
#'          theta = -log(0.6), I = c(50, 100, 150)/4)
#'
#' @export
exitprob <- function(b, a, theta, I) {
    .Call(`_lrstat_exitprob`, b, a, theta, I)
}

#' @title Quantile function of truncated piecewise exponential distribution
#' @description Obtains the quantile of a piecewise expoenential distribution
#' given that it exceeds a specified lower bound.
#'
#' @param probability The scalar probability corresponding to the quantile.
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda
#' @param lowerBound The left truncation time point for the survival time.
#' Defaults to 0 for no truncation.
#'
#' @return The quantile x such that
#' P(X > x | X > lowerBound) = 1 - probability.
#'
#' @keywords internal
#'
#' @examples
#' qtpwexp(probability = 0.3, piecewiseSurvivalTime = c(0, 6, 9, 15),
#'         lambda = c(0.025, 0.04, 0.015, 0.007), lowerBound = 0)
#'
#' @export
qtpwexp <- function(probability, piecewiseSurvivalTime, lambda, lowerBound) {
    .Call(`_lrstat_qtpwexp`, probability, piecewiseSurvivalTime, lambda, lowerBound)
}

