% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{repeatedPValue}
\alias{repeatedPValue}
\title{Repeated p-values for group sequential design}
\usage{
repeatedPValue(
  kMax,
  typeAlphaSpending = "sfOF",
  parameterAlphaSpending = NA,
  maxInformation = 1,
  p,
  information,
  spendingTime = NULL
)
}
\arguments{
\item{kMax}{The maximum number of stages.}

\item{typeAlphaSpending}{The type of alpha spending. One of the following:
"OF" for O'Brien-Fleming boundaries, "P" for Pocock boundaries,
"WT" for Wang & Tsiatis boundaries, "sfOF" for O'Brien-Fleming type
spending function, "sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function, "sfHSD" for Hwang,
Shi & DeCani spending function, "user" for user defined spending,
and "none" for no early efficacy stopping. Defaults to "sfOF".}

\item{parameterAlphaSpending}{The parameter value for the alpha spending.
Corresponds to Delta for "WT", rho for "sfKD", and gamma for "sfHSD".}

\item{maxInformation}{The target maximum information. Defaults to 1,
in which case, \code{information} represents \code{informationRates}.}

\item{p}{The raw p-values at look 1 to look \code{k}. It can be a matrix
with \code{k} columns for \code{k <= kMax}.}

\item{information}{The observed information by look. It can be a matrix
with \code{k} columns.}

\item{spendingTime}{The error spending time at each analysis, must be
increasing and less than or equal to 1. Defaults to NULL,
in which case, it is the same as \code{informationRates} derived from
\code{information} and \code{maxInformation}. It can be a matrix with
\code{k} columns.}
}
\value{
The repeated p-values at look 1 to look \code{k}.
}
\description{
Obtains the repeated p-values for a group sequential design.
}
\examples{

# Example 1: informationRates different from spendingTime
repeatedPValue(kMax = 3, typeAlphaSpending = "sfOF",
               maxInformation = 800,
               p = c(0.2, 0.15, 0.1),
               information = c(529, 700, 800),
               spendingTime = c(0.6271186, 0.8305085, 1))

# Example 2: Maurer & Bretz (2013), current look is not the last look
repeatedPValue(kMax = 3, typeAlphaSpending = "sfOF",
               p = matrix(c(0.0062, 0.017,
                            0.009, 0.13,
                            0.0002, 0.0035,
                            0.002, 0.06),
                          nrow=4, ncol=2),
               information = c(1/3, 2/3))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
