% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_latent.R
\name{plot_latent}
\alias{plot_latent}
\title{Plotting the latent space of fitted LSIRM model}
\usage{
plot_latent(lsrm_result, rotation = FALSE)
}
\arguments{
\item{lsrm_result}{List; The output list obtained by any lsrm function.}

\item{rotation}{Logical; If TRUE the latent positions are visualized after oblique (oblimin) rotation.}
}
\value{
\code{plot_latent} returns the plot of latent space visualize an interaction map that represents interactions between respondents and items.
}
\description{
\link{plot_latent} is used to plot the latent space of fitted LSIRM model.
}
\examples{
\donttest{
# generate example item response matrix
data     <- matrix(rbinom(500, size = 1, prob = 0.5),ncol=10,nrow=50)
lsirm_result <- lsirm1pl(data = data)
plot_latent(lsirm_result)
# use oblique rotation
plot_latent(lsirm_result, rotation = TRUE) 
}
}
