% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/durations.r
\name{duration}
\alias{duration}
\alias{dseconds}
\alias{dminutes}
\alias{dhours}
\alias{ddays}
\alias{dweeks}
\alias{dyears}
\alias{dmilliseconds}
\alias{dmicroseconds}
\alias{dnanoseconds}
\alias{dpicoseconds}
\alias{is.duration}
\title{Create a duration object.}
\usage{
duration(num = NULL, units = "seconds", ...)

dseconds(x = 1)

dminutes(x = 1)

dhours(x = 1)

ddays(x = 1)

dweeks(x = 1)

dyears(x = 1)

dmilliseconds(x = 1)

dmicroseconds(x = 1)

dnanoseconds(x = 1)

dpicoseconds(x = 1)

is.duration(x)
}
\arguments{
\item{num}{the number or a character vector of time units. In string
representation all unambiguous name units and abbreviations and ISO 8601
formats are supported; 'm' stands for month and 'M' for minutes unless ISO
8601 "P" modifier is present (see examples). Fractional units are
supported.}

\item{units}{a character string that specifies the type of units that num
refers to. When \code{num} is character, this argument is ignored.}

\item{...}{a list of time units to be included in the duration and their
amounts. Seconds, minutes, hours, days, and weeks are supported.}

\item{x}{numeric value of the number of units to be contained in the
duration.}
}
\value{
a duration object
}
\description{
\code{duration()} creates a duration object with the specified values. Entries
for different units are cumulative. durations display as the number of
seconds in a time span. When this number is large, durations also display an
estimate in larger units,; however, the underlying object is always recorded
as a fixed number of seconds. For display and creation purposes, units are
converted to seconds using their most common lengths in seconds. Minutes = 60
seconds, hours = 3600 seconds, days = 86400 seconds, weeks = 604800. Units
larger than weeks are not used due to their variability.
}
\details{
Durations record the exact number of seconds in a time span. They measure the
exact passage of time but do not always align with measurements
made in larger units of time such as hours, months and years.
This is because the length of larger time units can be affected
by conventions such as leap years
and Daylight Savings Time. Base R provides a second class for measuring
durations, the difftime class.

Duration objects can be easily created with the helper functions \code{\link[=dweeks]{dweeks()}},
\code{\link[=ddays]{ddays()}}, \code{\link[=dminutes]{dminutes()}}, \code{\link[=dseconds]{dseconds()}}. These objects can be added to and
subtracted to date- times to create a user interface similar to object
oriented programming.
}
\examples{

### Separate period and units vectors

duration(90, "seconds")
duration(1.5, "minutes")
duration(-1, "days")

### Units as arguments

duration(day = -1)
duration(second = 90)
duration(minute = 1.5)
duration(mins = 1.5)
duration(second = 3, minute = 1.5, hour = 2, day = 6, week = 1)
duration(hour = 1, minute = -60)

### Parsing

duration("2M 1sec")
duration("2hours 2minutes 1second")
duration("2d 2H 2M 2S")
duration("2days 2hours 2mins 2secs")
# Missing numerals default to 1. Repeated units are added up.
duration("day day")

### ISO 8601 parsing

duration("P3Y6M4DT12H30M5S")
duration("P23DT23H") # M stands for months
duration("10DT10M") # M stands for minutes
duration("P23DT60H 20min 100 sec") # mixing ISO and lubridate style parsing

# Comparison with characters (from v1.6.0)

duration("day 2 sec") > "day 1sec"


## ELEMENTARY CONSTRUCTORS:

dseconds(1)
dminutes(3.5)

x <- ymd_hms("2009-08-03", tz="America/Chicago")
x + ddays(1) + dhours(6) + dminutes(30)
x + ddays(100) - dhours(8)

class(as.Date("2009-08-09") + ddays(1)) # retains Date class
as.Date("2009-08-09") + dhours(12)
class(as.Date("2009-08-09") + dhours(12))
# converts to POSIXt class to accomodate time units

dweeks(1) - ddays(7)
c(1:3) * dhours(1)

# compare DST handling to durations
boundary <- ymd_hms("2009-03-08 01:59:59", tz="America/Chicago")
boundary + days(1) # period
boundary + ddays(1) # duration
is.duration(as.Date("2009-08-03")) # FALSE
is.duration(duration(days = 12.4)) # TRUE
}
\seealso{
\code{\link[=as.duration]{as.duration()}} \linkS4class{Duration}
}
\keyword{chron}
\keyword{classes}
