% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{agree_C}
\alias{agree_C}
\alias{agree_C_sparse}
\alias{agree_C_sparse}
\title{Fast C++ implementation of agreement vector for the element-wise comparison of 2 matrices}
\usage{
agree_C(mat_A, mat_B)

agree_C_sparse(mat_A, mat_B)
}
\arguments{
\item{mat_A}{a \code{nB x K} matrix of the observations to be matched. Must be integers.}

\item{mat_B}{a \code{nA x K} matrix of the database into which a match is looked for. Must be integers.}
}
\description{
Fast C++ implementation of agreement vector for the element-wise comparison of 2 matrices

\code{agree_C_sparse} uses sparse matrices.
}
\examples{
mat1 <- matrix(round(rnorm(n=1000, sd=1.2)), ncol=10, nrow=100)
mat2 <- rbind(mat1[1:10, ],
             matrix(round(rnorm(n=900, sd=1.2)), ncol=10, nrow=90)
             )
rownames(mat1) <- paste0("A", 1:nrow(mat1))
rownames(mat1) <- paste0("B", 1:nrow(mat1))
mat1 <- 1*(mat1>1)
mat2 <- 1*(mat2>1)

}
