% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{context}
\alias{context}
\title{Context object}
\description{
Context object storing information about the model training context.
See also \link{ctx}.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{records}}{stores information about values logged with \code{self$log}.}

\item{\code{device}}{allows querying the current accelerator device}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-log}{\code{context$log()}}
\item \href{#method-log_metric}{\code{context$log_metric()}}
\item \href{#method-get_log}{\code{context$get_log()}}
\item \href{#method-get_metrics}{\code{context$get_metrics()}}
\item \href{#method-get_metric}{\code{context$get_metric()}}
\item \href{#method-get_formatted_metrics}{\code{context$get_formatted_metrics()}}
\item \href{#method-get_metrics_df}{\code{context$get_metrics_df()}}
\item \href{#method-set_verbose}{\code{context$set_verbose()}}
\item \href{#method-clone}{\code{context$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-log"></a>}}
\if{latex}{\out{\hypertarget{method-log}{}}}
\subsection{Method \code{log()}}{
Allows logging arbitrary information in the \code{ctx}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{context$log(what, set, value, index = NULL, append = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{what}}{(string) What you are logging.}

\item{\code{set}}{(string) Usually 'train' or 'valid' indicating the set you want
to lot to. But can be arbitrary info.}

\item{\code{value}}{value to log}

\item{\code{value}}{Arbitrary value to log.}

\item{\code{index}}{Index that this value should be logged. If \code{NULL} the value
is added to the end of list, otherwise the index is used.}

\item{\code{append}}{If \code{TRUE} and a value in the corresponding index already
exists, then value is appended to the current value. If \code{FALSE} value
is overwritten in favor of the new value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-log_metric"></a>}}
\if{latex}{\out{\hypertarget{method-log_metric}{}}}
\subsection{Method \code{log_metric()}}{
Log a metric gen its name and value.
Metric values are indexed by epoch.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{context$log_metric(name, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name of the metric}

\item{\code{value}}{value to log}

\item{\code{value}}{Arbitrary value to log.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_log"></a>}}
\if{latex}{\out{\hypertarget{method-get_log}{}}}
\subsection{Method \code{get_log()}}{
Get an specific value from the log.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{context$get_log(what, set, index = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{what}}{(string) What you are logging.}

\item{\code{set}}{(string) Usually 'train' or 'valid' indicating the set you want
to lot to. But can be arbitrary info.}

\item{\code{index}}{Index that this value should be logged. If \code{NULL} the value
is added to the end of list, otherwise the index is used.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_metrics"></a>}}
\if{latex}{\out{\hypertarget{method-get_metrics}{}}}
\subsection{Method \code{get_metrics()}}{
Get all metric given an epoch and set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{context$get_metrics(set, epoch = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{set}}{(string) Usually 'train' or 'valid' indicating the set you want
to lot to. But can be arbitrary info.}

\item{\code{epoch}}{The epoch you want to extract metrics from.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_metric"></a>}}
\if{latex}{\out{\hypertarget{method-get_metric}{}}}
\subsection{Method \code{get_metric()}}{
Get the value of a metric given its name, epoch and set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{context$get_metric(name, set, epoch = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name of the metric}

\item{\code{set}}{(string) Usually 'train' or 'valid' indicating the set you want
to lot to. But can be arbitrary info.}

\item{\code{epoch}}{The epoch you want to extract metrics from.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_formatted_metrics"></a>}}
\if{latex}{\out{\hypertarget{method-get_formatted_metrics}{}}}
\subsection{Method \code{get_formatted_metrics()}}{
Get formatted metrics values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{context$get_formatted_metrics(set, epoch = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{set}}{(string) Usually 'train' or 'valid' indicating the set you want
to lot to. But can be arbitrary info.}

\item{\code{epoch}}{The epoch you want to extract metrics from.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_metrics_df"></a>}}
\if{latex}{\out{\hypertarget{method-get_metrics_df}{}}}
\subsection{Method \code{get_metrics_df()}}{
Get a data.frame containing all metrics.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{context$get_metrics_df()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_verbose"></a>}}
\if{latex}{\out{\hypertarget{method-set_verbose}{}}}
\subsection{Method \code{set_verbose()}}{
Allows setting the \code{verbose} attribute.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{context$set_verbose(verbose = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{boolean. If \code{TRUE} verbose mode is used. If \code{FALSE} non verbose.
if \code{NULL} we use the result of \code{\link[=interactive]{interactive()}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{context$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
