% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{luz_metric_binary_accuracy_with_logits}
\alias{luz_metric_binary_accuracy_with_logits}
\title{Binary accuracy with logits}
\usage{
luz_metric_binary_accuracy_with_logits(threshold = 0.5)
}
\arguments{
\item{threshold}{value used to classifiy observations between 0 and 1.}
}
\value{
Returns new Luz metric.
}
\description{
Computes accuracy for binary classification problems where the model
return logits. Commonly used together with \code{\link[torch:nn_bce_with_logits_loss]{torch::nn_bce_with_logits_loss()}}.
}
\details{
Probabilities are generated using \code{\link[torch:nnf_sigmoid]{torch::nnf_sigmoid()}} and \code{threshold} is used to
classify between 0 or 1.
}
\examples{
if (torch::torch_is_installed()) {
library(torch)
metric <- luz_metric_binary_accuracy_with_logits(threshold = 0.5)
metric <- metric$new()
metric$update(torch_randn(100), torch::torch_randint(0, 1, size = 100))
metric$compute()
}
}
\seealso{
Other luz_metrics: 
\code{\link{luz_metric_accuracy}()},
\code{\link{luz_metric_binary_accuracy}()},
\code{\link{luz_metric_binary_auroc}()},
\code{\link{luz_metric_mae}()},
\code{\link{luz_metric_mse}()},
\code{\link{luz_metric_multiclass_auroc}()},
\code{\link{luz_metric_rmse}()},
\code{\link{luz_metric}()}
}
\concept{luz_metrics}
