% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module2_summary.pipeline.R
\name{ggir.summary}
\alias{ggir.summary}
\title{Description of all accelerometer files in the GGIR output}
\usage{
ggir.summary(
  bindir = NULL,
  outputdir,
  studyname,
  numericID = FALSE,
  sortByid = "filename",
  subdir = "summary",
  part5FN = "WW_L50M125V500_T5A5",
  QChours.alpha = 16,
  filename2id = NULL,
  desiredtz = "US/Eastern",
  trace = FALSE
)
}
\arguments{
\item{bindir}{\code{character} Directory where the accelerometer files are stored or list for the purpose of extracting the bin file list. Default=NULL when it is not available and therefore the bin file list is extracted from the /meta/basic folder of the GGIR output.}

\item{outputdir}{\code{character} Directory where the GGIR output was stored.}

\item{studyname}{\code{character} Specify the study name that used in the output file names}

\item{numericID}{\code{logical} Specify if the ID is numeric when checking ID errors in module2. Default is FALSE.}

\item{sortByid}{\code{character}  Specify the name of "ID" for each accelerometer file in the report of module2. The value could be "newID","id" and "filename". Defaut is "filename".}

\item{subdir}{\code{character} Sub-directory where the summary output was stored under the current directory. Defaut is "summary".}

\item{part5FN}{\code{character}  Specify which output is used in the GGIR part5 results. Defaut is "WW_L50M125V500_T5A5", which means that part5_daysummary_WW_L50M125V500_T5A5.csv and part5_personsummary_WW_L50M125V500_T5A5.csv are used in the analysis.}

\item{QChours.alpha}{\code{number}  Minimum required number of valid hours in day specific analysis as a quality control step in module2. Default is 16 hours.}

\item{filename2id}{\code{R function}  User defined function for converting filename to sample IDs. Default is NULL.}

\item{desiredtz}{\code{charcter}  desired timezone: see also http://en.wikipedia.org/wiki/Zone.tab. Used in g.inspectfile(). Default is "US/Eastern".}

\item{trace}{\code{logical}  Specify if the intermediate results is printed when the function was executed. Default is FALSE.}
}
\value{
Four files were written to the specified sub-directory
\item{      studyname_ggir_output_summary.xlsx}{This excel file includs 9 pages as follows,} 
     \item{          page 1}{ List of files in the GGIR output} 
     \item{          page 2}{ Summary of files }
     \item{          page 3}{ List of duplicate IDs }
     \item{          page 4}{ ID errors }
     \item{          page 5}{ Number of valid days }
     \item{          page 6}{ Table of number of valid/missing days }
     \item{          page 7}{ Missing patten }
     \item{          page 8}{ Frequency of the missing pattern }
     \item{          page 9}{ Description of all accelerometer files}  
     \item{          page 10}{ Inspects accelerometer file for key information, including: monitor brand, sample frequency and file header}  
\item{      studyname_ggir_output_summary_plot.pdf}{Some plots such as the number of valid days, which were included in the module5_studyname_Data_process_report.html file as well.}
\item{      part24daysummary.info.csv}{Intermediate results for description of each accelerometer file.}
\item{      studyname_samples_remove_temp.csv}{Create studyname_samples_remove.csv file by filling "remove" in the "duplicate" column in this template. If duplicate="remove",  the accelerometer files will not be used in the data analysis of module 5-7.}
}
\description{
Description of all accelerometer files in the GGIR output and this script was executed when mode=2 in the main call.
}
