% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flag.R
\name{flag}
\alias{flag}
\title{Criteria Helper Functions for Custom Search}
\usage{
flag(flag, negate = FALSE)
}
\arguments{
\item{flag}{A string specifying the flag to be used for filtering messages.
Use \link{flag_options} to list the flags available in your IMAP server.}

\item{negate}{If \code{TRUE}, negates the search and seeks for
"NOT search_criterion". Default is \code{FALSE}.}
}
\value{
A search string to be used as a \code{custom_request} parameter in
    \link{custom_search} function.
}
\description{
Criteria helper functions to be combined inside a operator helper
    function as a custom request in \link{custom_search}.
}
\examples{

\dontrun{

# configure IMAP
library(mRpostman)
imapconf <- configure_imap(url="imaps://imap.gmail.com",
                           username="your_gmail_user",
                           password=rstudioapi::askForPassword()
                          )

# search
result <- imapconf \%>\%
    select_mailbox(mbox = "INBOX") \%>\%
    custom_search(custom_request = AND(flag("UNSEEN"),
                                       smaller_than(size = 512000),
                                       negate = TRUE))
# searches for messages with Flag "UNSEEN" AND NOT Smaller Than  512KB.

}

}
\seealso{
Other customsearch helper functions: \code{\link{AND}},
  \code{\link{OR}}, \code{\link{before}},
  \code{\link{larger_than}}, \code{\link{older_than}},
  \code{\link{on}}, \code{\link{sent_before}},
  \code{\link{sent_on}}, \code{\link{sent_since}},
  \code{\link{since}}, \code{\link{smaller_than}},
  \code{\link{string}}, \code{\link{younger_than}}
}
\concept{customsearch helper functions}
