% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates.R
\name{formatDate}
\alias{formatDate}
\alias{is.Date}
\alias{year}
\alias{month}
\alias{day}
\title{Format Dates}
\usage{
formatDate(x, format = "dmY", sep = "/", century = NULL)

is.Date(x)

year(x)

month(x)

day(x)
}
\arguments{
\item{x}{a character or numeric object}

\item{format}{only for character vectors:}

\item{sep}{separator character for date components}

\item{century}{specify either 2000 or 1900 for two-digit years}
}
\description{
\code{formatDate} converts characters or numbers to dates.
\code{is.Date} indicates which elements are Dates.
}
\details{
\code{dmy} represents \code{dd mm YYYY} format.
In combination with separators from \code{sep}, this can change to
several date formats.
For example, \code{dmy} + \code{-} convert to
\code{dd-mm-yyyy} format.

\strong{Possible conversions}

\enumerate{
\item \code{dmy} + \code{-} >>> \code{dd-mm-yyyy}
\item \code{mdy} + \code{-} >>> \code{mm-dd-yyyy}
\item \code{ymd} + \code{-} >>> \code{yyyy-mm-dd}
\item \code{dmy} + \code{/} >>> \code{dd/mm/yyyy}
\item \code{mdy} + \code{/} >>> \code{mm/dd/yyyy}
\item \code{ymd} + \code{/} >>> \code{yyyy/mm/dd}
}

\strong{Numeric conversions}

Origin is set at \code{1899-12-30}.

See \code{\link{as.Date}} for more date formats.
}
\examples{


## convert strings to dates
x <- c("2019-01-15", "2019-01-20", "2019-01-21", "2019-01-22")

# check if it is a Date format
is.Date(x)

y <- formatDate(x, "Ymd", "-")

# check if it is a Date format
is.Date(y)
y



## convert numbers to dates
x <- 42705:42710
y <- formatDate(x)
is.Date(y)
y


## get day, month or year
day(y)
month(y)
year(y)

}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
