% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keep.R
\name{keep}
\alias{keep}
\alias{drop}
\alias{arrange}
\alias{filter}
\title{\code{Keep}, \code{drop} and \code{filter} variables; \code{arrange} observations}
\usage{
keep(data, ...)

drop(data, ...)

arrange(data, ...)

filter(data, ...)
}
\arguments{
\item{data}{Dataset}

\item{...}{Variables or conditions in \code{filter()}}
}
\value{
Modified Dataset
}
\description{
\code{keep()} or \code{drop()} variables within dataframe

\code{arrange()} sorts variables or columns

\code{filter()} keeps observations that satisfy specified conditions
}
\section{Select Variables}{
\code{keep()} removes unspecified variables from the dataset.
Variables are also rearranged based on the order they are mentioned.

\preformatted{keep(data, var1, var2, var3, etc)}

\code{drop()} works the opposite of \code{keep()} removed specified variables
from the dataset.

\preformatted{drop(data, var5, var6, var7, etc)}
}

\section{Sort}{
\code{arrange()} sorts the dataset by specifying variables. The minus symbol \code{-}
indicates descending order.

\preformatted{arrange(data, var1, var2, -var3, var4)}
}

\section{Filter}{
\code{filter} keeps observations that meet the specified conditions. If conditions
are specified by comma, they are joined by \code{AND} operators

\preformatted{filter(data, var1 == var2 | var3 > var4)}

\preformatted{filter(data, var1 == var2, var3 > var4)}
}

\examples{

## use infert data
data(infert)
codebook(infert)

## DEMONSTRATION: KEEP
## suppose we want to keep education, age, induced and case
infert.new <- keep(infert, education, age, induced, case)
codebook(infert.new)

## use colon separator :
infert.new <- keep(infert, education:case)
codebook(infert.new)

## change the order of variables
infert.new <- keep(infert, stratum, pooled.stratum, education:spontaneous)
codebook(infert.new)



}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
