% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summ.R
\name{summ}
\alias{summ}
\title{Number Summary for numerical data}
\usage{
summ(data, ..., by = NULL, na.rm = FALSE, rnd = 1)
}
\arguments{
\item{data}{Dataset}

\item{...}{Variable or multiple variables
Colon separator \code{:} can be used to specify multiple variables.}

\item{by}{Varaiable for cross-tabulation}

\item{na.rm}{A logical value to specify missing values,}

\item{rnd}{specify rounding of numbers. See \code{\link{round}}.}
}
\value{
summary measures as \code{data.frame}
}
\description{
\code{summ()} generates summary statistics for numerical data as well as
grouped summary measures.
}
\details{
\code{summ()} reports seven number summary statistics, normality and other additional
metadata.

\preformatted{summ(data, var1)}

\preformatted{summ(data, var1, var2, var3:var5, var10)}

\preformatted{summ(data)}

Normality test is perfomed by Shapiro-Wilk Normality Test. See more at
\code{\link{shapiro.test}}.

'
\strong{ANNOTATIONS}

\code{Obs.} = observation

\code{NA.} = missing data

\code{Mean} = Mean value

\code{Std.Dev} = Standard deviation

\code{Median} = Median value

\code{Q1} = First quartile or percentile

\code{Q3} = Third quartile or percentile

\code{Min} = Minimum value

\code{Max} = Maximum value

\code{Normality} = P-value from Shapiro-Wilk Normality Test

\strong{\verb{Grouped Summary Measures}}

If \code{by} is specified, grouped summary measures are calculated and
produced five number summary, excluding minimum and maximum. In addition,
if levels of \code{by} are more than 2, p-values from ANOVA and Kruskal Wallis tests
are displayed. Otherwise, Student's t-test and Wilcoxon signed rank test are
measured and their respective p-values are tabulated.

There are two parts of the final table. The first part tabulates
grouped summary measures and second part tabulates one-variable summary
measures for corresponding variables.

\preformatted{summ(data, var1, var2, by = var3)}

\preformatted{summ(data, var1, var2, var3:var5, var10, by = var11)}

\preformatted{summ(data, by = var11)}

\strong{Using colon \code{:} spearator}

Colon separator \code{:} can be used to indicate sequence of variables.

\preformatted{summ(data, var1, var2, var3:var5, var10)}
}
\examples{

## use iris dataset
data(iris)

summ(iris, Sepal.Length)
summ(iris, Sepal.Length:Petal.Width)

summ(iris)

}
\references{
Betty R. Kirkwood, Jonathan A.C. Sterne (2006, ISBN:978–0–86542–871–3)
}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
