% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mable.r
\name{optim.gcp}
\alias{optim.gcp}
\title{Choosing optimal model degree by gamma change-point method}
\usage{
optim.gcp(obj)
}
\arguments{
\item{obj}{a class "mable" or 'mable_reg' object containig a vector \code{M=(m0,m1)}, \code{lk},
loglikelihoods evaluated evaluated at \eqn{m\in\{m_0,\ldots, m_1\}}}
}
\value{
a list with components
\itemize{
  \item \code{m} the selected optimal degree \code{m}
  \item \code{M} the vector \code{(m0,m1)}, where \code{m1} is the last candidate when the search stoped
  \item \code{mloglik}  the maximum log-likelihood at degree \code{m}
  \item \code{support} supporting interval \code{(a,b)}
  \item \code{lk} log-likelihoods evaluated at \eqn{m\in\{m_0,\ldots, m_1\}}
  \item \code{lr} likelihood ratios for change-points evaluated at \eqn{m\in\{m_0+1,\ldots, m_1\}}
  \item \code{pval} the p-values of the change-point tests for choosing optimal model degree
  \item \code{chpts} the change-points chosen with the given candidate model degrees
}
}
\description{
Choose an optimal degree using gamma change-point model with two
  changing shape and scale parameters.
}
\examples{
\donttest{
 # simulated data
 p<-c(1:5,5:1)
 p<-p/sum(p)
 x<-rmixbeta(100, p)
 res1<-mable(x, M=c(2, 50), IC="none")
 m1<-res1$m[1]
 res2<-optim.gcp(res1)
 m2<-res2$m
 op<-par(mfrow=c(1,2))
 plot(res1, which="likelihood", add=FALSE)
 plot(res2, which="likelihood")
 #segments(m2, min(res1$lk), m2, res2$mloglik, col=4)
 plot(res1, which="change-point", add=FALSE)
 plot(res2, which="change-point")
 par(op)
}
}
