% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolCodeLabels.R
\name{toolCodeLabels}
\alias{toolCodeLabels}
\title{Tool: CodeLabels}
\usage{
toolCodeLabels(get = NULL, add = NULL)
}
\arguments{
\item{get}{A vector of hash codes which should be replaced}

\item{add}{Additional entries that should be added to the dictionary. Need to be
provided in the form of a named vector with the structure c(<label>=<hash>),
e.g. c(h12="62eff8f7")}
}
\value{
A vector with either labels (if available) or hash codes (if no label was available).
}
\description{
This function replaces a hash code (e.g. regioncode) or another cryptic
code with a human readable code via a given dictionary.
This can be useful to make outputs better readable in cases where hash
codes are already known to the user.
If not entry exists in the dictionary the hash code is returned again.
}
\examples{
toolCodeLabels("62eff8f7")

}
\seealso{
\code{\link{regionscode}}
}
\author{
Jan Philipp Dietrich
}
