% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-dictionaries_functions.R
\name{as_data_dict_mlstr}
\alias{as_data_dict_mlstr}
\title{Validate and coerce any object as an Opal data dictionary format}
\usage{
as_data_dict_mlstr(object, as_data_dict = FALSE, name_standard = FALSE)
}
\arguments{
\item{object}{A potential valid data dictionary to be coerced.}

\item{as_data_dict}{Whether the input data dictionary should not be coerced
with specific format restrictions for compatibility with other
Maelstrom Research software. FALSE by default.}

\item{name_standard}{Whether the input data dictionary has variable names
compatible with Maelstrom Research ecosystem, including Opal)or not.
FALSE by default.}
}
\value{
A list of data frame(s) with \code{madshapR::class} 'data_dict_mlstr'.
}
\description{
Validates the input object as a valid data dictionary compliant with formats
used in Maelstrom Research ecosystem, including Opal, and returns it with
the appropriate \code{madshapR::class} attribute. This function mainly helps
validate input within other functions of the package but could be used to
check if an object is valid for use in a function.
}
\details{
A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.

The object may be specifically formatted to be compatible with additional
\href{https://maelstrom-research.org/page/software}{Maelstrom Research software},
in particular \href{https://www.obiba.org/pages/products/opal/}{Opal environments}.
}
\examples{
{

# use madshapR_DEMO provided by the package

data_dict <- madshapR_DEMO$data_dict_MELBOURNE
as_data_dict_mlstr(madshapR_DEMO$data_dict_MELBOURNE)

}

}
\seealso{
For a better assessment, please use \code{\link[=data_dict_evaluate]{data_dict_evaluate()}}.
}
