% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-dictionaries_functions.R
\name{data_dict_ungroup}
\alias{data_dict_ungroup}
\title{Ungroup data dictionary}
\usage{
data_dict_ungroup(data_dict)
}
\arguments{
\item{data_dict}{A list of data frame(s) representing metadata to be
transformed.}
}
\value{
A list of data frame(s) identifying a workable data dictionary structure.
}
\description{
Ungroups the data dictionary element(s). This function ungroups both the
'Variables' and 'Categories' elements (if both are grouped data frames).
This function is analogous to running \code{\link[dplyr:group_by]{dplyr::ungroup()}}.
\code{\link[=data_dict_group_by]{data_dict_group_by()}} allows to group a data dictionary and this function
reverses the effect.
}
\details{
A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.
}
\examples{
{

# use madshapR_DEMO provided by the package
# Create a list of data dictionaries where the column 'table' is added to 
# refer to the associated dataset. The object created is not a 
# data dictionary per say, but can be used as a structure which can be 
# shaped into a data dictionary.

library(dplyr)

data_dict_list <- list(
  data_dict_1 <- madshapR_DEMO$data_dict_TOKYO ,
  data_dict_2 <- madshapR_DEMO$data_dict_MELBOURNE)
names(data_dict_list) = c("dataset_TOKYO","dataset_MELBOURNE")

data_dict_nest <-
  data_dict_list_nest(data_dict_list, name_group = 'table') \%>\%
  data_dict_group_by(col = "table")

 data_dict_ungroup(data_dict_nest)
}

}
\seealso{
\code{\link[dplyr:group_by]{dplyr::ungroup()}}
\code{\link[=data_dict_group_by]{data_dict_group_by()}}
}
