% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-dataset_functions.R
\name{data_extract}
\alias{data_extract}
\title{Create an empty dataset from a data dictionary}
\usage{
data_extract(data_dict, data_dict_apply = FALSE)
}
\arguments{
\item{data_dict}{A list of data frame(s) representing metadata.}

\item{data_dict_apply}{Whether data dictionary(ies) should be applied to
associated dataset(s), creating labelled dataset(s) with variable attributes.
Any previous attributes will be preserved. FALSE by default.}
}
\value{
A data frame identifying the dataset created from the variable names list in
'Variables' element of the data dictionary.
}
\description{
Creates an empty dataset using information contained in a data dictionary.
The column names are taken from 'name' in the 'Variables' element of the
data dictionary. If a 'valueType' or alternatively 'typeof' column is
provided, the class of each column is set accordingly (default is text).
}
\details{
A dataset is a data table containing variables. A dataset object is a
data frame and can be associated with a data dictionary. If no
data dictionary is provided with a dataset, a minimum workable
data dictionary will be generated as needed within relevant functions.
Identifier variable(s) for indexing can be specified by the user.
The id values must be non-missing and will be used in functions that
require it. If no identifier variable is specified, indexing is
handled automatically by the function.

A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.
}
\examples{
{

# use madshapR_DEMO provided by the package

data_dict <- madshapR_DEMO$data_dict_MELBOURNE
data_extract(data_dict)

}

}
