% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimCode.R
\name{dimCode}
\alias{dimCode}
\title{dimCode}
\usage{
dimCode(dim, x, missing = 0)
}
\arguments{
\item{dim}{A vector of dimension numbers or dimension names which should be
translated}

\item{x}{MAgPIE object in which the dimensions should be searched for.}

\item{missing}{Either a value to which a dimension should be set in case
that it is not found (default is 0), or "stop" indicating that the function
should throw an error in these cases.}
}
\value{
A dimension code identifying the dimension. Either a integer which
represents the main dimensions (1=spatial, 2=temporal, 3=data) or a numeric,
representing the subdimensions of a dimension (e.g. 3.2 for the second data
dimension).
}
\description{
Function converts a dimension name or number to a dimension Code used for
MAgPIE objects
}
\examples{

data(population_magpie)
dimCode(c("t","scenario","blablub"),population_magpie)

}
\seealso{
\code{\link{mselect}}, \code{\link{getDim}}
}
\author{
Jan Philipp Dietrich
}
