% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.magpie.ncdf.R
\name{write.magpie.ncdf}
\alias{write.magpie.ncdf}
\title{write.magpie.ncdf}
\usage{
write.magpie.ncdf(
  x,
  file,
  nc_compression = 9,
  var_style = "fullname",
  comment = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{MAgPIE object. Has to be on half degree resolution. If x as comments in attr, they are plotted as global attributes.}

\item{file}{file path as provided in write.magpie}

\item{nc_compression}{Only used if filetype="nc". Sets the compression
level for netCDF files (default is 9). If set to an integer between 1 (least
compression) and 9 (most compression), the netCDF file is written in netCDF
version 4 format. If set to NA, the netCDF file is written in netCDF version
3 format.}

\item{var_style}{change between variable naming in nc-file; "fullname" for ungrouped name, "grouped" for variable names divided into sub-groups}

\item{comment}{Vector of comments (also used for setting the unit). Comments are set as global attributes in the netcdf file. Format of comments: "indicator: comment" (e.g. "unit: Share of land area per grid cell")}

\item{verbose}{Boolean deciding about whether function should be verbose or not}
}
\value{
netcdf file. Writes one file per year per
data column. In the case that more than one year and data column is supplied
several files are written with the structure filename_year_datacolumn.asc. In the case several data dimensions exist, they are saved as subcategories.
}
\description{
Writes magpie object into netcdf4 file.
}
\seealso{
\code{\link{write.magpie}}
}
\author{
Jan Philipp Dietrich, Florian Humpenoeder, Benjamin Leon Bodirsky, Stephen Bi, Kristine Karstens
}
