% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magpply.R
\name{magpply}
\alias{magpply}
\title{magpply}
\usage{
magpply(X, FUN, MARGIN, ..., integrate = FALSE)
}
\arguments{
\item{X}{magpie object}

\item{FUN}{function that shall be applied X}

\item{MARGIN}{dimension over which FUN shall be applied (like a loop over that dimension). This dimension will be preserved in the output object}

\item{...}{further parameters passed on to FUN}

\item{integrate}{if TRUE, the output will be filled into an magpie object of the same dimensionality as X}
}
\value{
magpie object
}
\description{
apply command for magpieobjects. Very efficient for replacing loops.
}
\examples{

\dontrun{ 
data("population_magpie")
magpply(population_magpie,FUN=sum,MARGIN=2)
fourdim<-population_magpie*setNames(population_magpie,c("jkk","lk"))
magpply(fourdim,FUN=sum,MARGIN=c(1,3.1))
magpply(fourdim,FUN=function(x){return(x+1)},MARGIN=c(1,3.1),integrate=TRUE)
}

}
\author{
Benjamin Leon Bodirsky
}
