% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gadget.R
\name{preview_mailmerge}
\alias{preview_mailmerge}
\title{Preview mailmerge as shiny gadget in RStudio preview pane.}
\usage{
preview_mailmerge(x)
}
\arguments{
\item{x}{mailmerge_preview object, from \link{mail_merge}}
}
\value{
A 'shiny' gadget, see also \link[shiny:runGadget]{shiny::runGadget}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
## ---- input-data --------------------------------------------------------

dat <-  data.frame(
  email      = c("friend@example.com", "foe@example.com"),
  first_name = c("friend", "foe"),
  thing      = c("something good", "something bad"),
  stringsAsFactors = FALSE
)

## ---- markdown-message --------------------------------------------------

msg <- '
---
subject: "**Hello, {first_name}**"
---

Hi, **{first_name}**

I am writing to tell you about **{thing}**.

{if (first_name == "friend") "Regards" else ""}


Me
'



## ---- display shiny gadget ----------------------------------------------

if (interactive()) {
  dat \%>\%
    mail_merge(msg) \%>\%
    preview_mailmerge()
}



}
\seealso{
\link{mail_merge}
}
